/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.engine;

import jakarta.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.rooftop.netx.engine.AbstractSagaDispatcher;
import org.rooftop.netx.engine.AbstractSagaListener;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.logging.LoggingSupportsKt;
import reactor.core.Disposable;
import reactor.core.publisher.BufferOverflowStrategy;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fH$J\b\u0010\u0010\u001a\u00020\u0011H$J\b\u0010\u0012\u001a\u00020\u0011H\u0003J\u0006\u0010\u0013\u001a\u00020\u0011J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\f\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rooftop/netx/engine/AbstractSagaListener;", "", "backpressureSize", "", "sagaDispatcher", "Lorg/rooftop/netx/engine/AbstractSagaDispatcher;", "(ILorg/rooftop/netx/engine/AbstractSagaDispatcher;)V", "disposable", "Lreactor/core/Disposable;", "isShutdown", "", "receive", "Lreactor/core/publisher/Flux;", "Lkotlin/Pair;", "Lorg/rooftop/netx/engine/core/Saga;", "", "shutdownCascade", "", "shutdownGracefully", "subscribeStream", "restartWhenTerminated", "T", "netx"})
public abstract class AbstractSagaListener {
    private final int backpressureSize;
    @NotNull
    private final AbstractSagaDispatcher sagaDispatcher;
    private Disposable disposable;
    private boolean isShutdown;

    public AbstractSagaListener(int backpressureSize, @NotNull AbstractSagaDispatcher sagaDispatcher) {
        Intrinsics.checkNotNullParameter((Object)sagaDispatcher, (String)"sagaDispatcher");
        this.backpressureSize = backpressureSize;
        this.sagaDispatcher = sagaDispatcher;
    }

    public final void subscribeStream() {
        Flux flux = this.receive().publishOn(Schedulers.boundedElastic()).onBackpressureBuffer(this.backpressureSize, BufferOverflowStrategy.DROP_LATEST).doOnNext(arg_0 -> AbstractSagaListener.subscribeStream$lambda$0(subscribeStream.1.INSTANCE, arg_0)).flatMap(arg_0 -> AbstractSagaListener.subscribeStream$lambda$1((Function1)new Function1<Pair<? extends Saga, ? extends String>, Publisher<? extends String>>(this){
            final /* synthetic */ AbstractSagaListener this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends String> invoke(Pair<Saga, String> pair) {
                Saga saga2 = (Saga)pair.component1();
                String messageId = (String)pair.component2();
                return (Publisher)LoggingSupportsKt.warningOnError(AbstractSagaListener.access$getSagaDispatcher$p(this.this$0).dispatch(saga2, messageId), "Error occurred when listen saga id " + saga2.getId());
            }
        }, arg_0)).onErrorResume(arg_0 -> AbstractSagaListener.subscribeStream$lambda$2(subscribeStream.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"onErrorResume(...)");
        Disposable disposable = this.restartWhenTerminated(flux).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.disposable = disposable;
    }

    @NotNull
    protected abstract Flux<Pair<Saga, String>> receive();

    private final <T> Flux<T> restartWhenTerminated(Flux<T> $this$restartWhenTerminated) {
        Flux flux = $this$restartWhenTerminated.doAfterTerminate(() -> AbstractSagaListener.restartWhenTerminated$lambda$3(this));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doAfterTerminate(...)");
        return flux;
    }

    @PreDestroy
    private final void shutdownGracefully() {
        Disposable disposable = this.disposable;
        if (disposable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"disposable");
            disposable = null;
        }
        disposable.dispose();
        this.shutdownCascade();
        LoggingSupportsKt.info("Shutdown SagaListenerSupporter gracefully");
    }

    protected abstract void shutdownCascade();

    private static final void subscribeStream$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher subscribeStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher subscribeStream$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void restartWhenTerminated$lambda$3(AbstractSagaListener this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.isShutdown) {
            this$0.subscribeStream();
        }
    }

    public static final /* synthetic */ AbstractSagaDispatcher access$getSagaDispatcher$p(AbstractSagaListener $this) {
        return $this.sagaDispatcher;
    }
}

