/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.engine;

import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.rooftop.netx.api.NotFoundDispatchFunctionException;
import org.rooftop.netx.api.SagaCommitEvent;
import org.rooftop.netx.api.SagaCommitListener;
import org.rooftop.netx.api.SagaEvent;
import org.rooftop.netx.api.SagaJoinEvent;
import org.rooftop.netx.api.SagaJoinListener;
import org.rooftop.netx.api.SagaManager;
import org.rooftop.netx.api.SagaRollbackEvent;
import org.rooftop.netx.api.SagaRollbackListener;
import org.rooftop.netx.api.SagaStartEvent;
import org.rooftop.netx.api.SagaStartListener;
import org.rooftop.netx.api.SuccessWith;
import org.rooftop.netx.core.Codec;
import org.rooftop.netx.engine.AbstractDispatchFunction;
import org.rooftop.netx.engine.MonoDispatchFunction;
import org.rooftop.netx.engine.MonoDispatchFunctionKt;
import org.rooftop.netx.engine.NotPublishDispatchFunction;
import org.rooftop.netx.engine.NotPublishDispatchFunctionKt;
import org.rooftop.netx.engine.OrchestrateDispatchFunction;
import org.rooftop.netx.engine.OrchestrateDispatchFunctionKt;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.core.SagaState;
import org.rooftop.netx.engine.logging.LoggingSupportsKt;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0010H$J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0010J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH$J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J#\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0\u001d0$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0014H\u0007J\u0016\u0010(\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0002J\u0016\u0010*\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J$\u0010-\u001a\u0006\u0012\u0002\b\u00030.*\u0006\u0012\u0002\b\u00030.2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\f\u0010/\u001a\u00020\"*\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/rooftop/netx/engine/AbstractSagaDispatcher;", "", "codec", "Lorg/rooftop/netx/core/Codec;", "sagaManager", "Lorg/rooftop/netx/api/SagaManager;", "(Lorg/rooftop/netx/core/Codec;Lorg/rooftop/netx/api/SagaManager;)V", "functions", "", "Lorg/rooftop/netx/engine/core/SagaState;", "", "Lorg/rooftop/netx/engine/AbstractDispatchFunction;", "ack", "Lreactor/core/publisher/Mono;", "Lkotlin/Pair;", "Lorg/rooftop/netx/engine/core/Saga;", "", "saga", "messageId", "addOrchestrate", "", "handler", "addOrchestrate$netx", "addOrchestrateFunctions", "dispatch", "extractEvent", "findHandlers", "", "getEventType", "Lkotlin/reflect/KClass;", "annotation", "", "getMatchedSagaState", "getNextSagaState", "Lorg/rooftop/netx/engine/AbstractDispatchFunction$NextSagaState;", "getNoRollbackFor", "", "", "(Ljava/lang/annotation/Annotation;)[Lkotlin/reflect/KClass;", "initHandler", "initMonoFunctions", "foundHandlers", "initNotPublisherFunctions", "mapSagaEvent", "Lorg/rooftop/netx/api/SagaEvent;", "ackWhenComplete", "Lreactor/core/publisher/Flux;", "toNextSagaState", "Lorg/rooftop/netx/api/SuccessWith;", "Companion", "netx"})
@SourceDebugExtension(value={"SMAP\nAbstractSagaDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSagaDispatcher.kt\norg/rooftop/netx/engine/AbstractSagaDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,298:1\n766#2:299\n857#2,2:300\n1855#2:302\n1855#2,2:303\n1856#2:305\n1549#2:307\n1620#2,3:308\n766#2:312\n857#2,2:313\n1855#2:315\n1855#2,2:316\n1856#2:318\n766#2:319\n857#2,2:320\n1855#2:322\n1855#2,2:323\n1856#2:325\n215#3:306\n216#3:311\n26#4:326\n*S KotlinDebug\n*F\n+ 1 AbstractSagaDispatcher.kt\norg/rooftop/netx/engine/AbstractSagaDispatcher\n*L\n129#1:299\n129#1:300,2\n131#1:302\n133#1:303,2\n131#1:305\n163#1:307\n163#1:308,3\n174#1:312\n174#1:313,2\n176#1:315\n178#1:316,2\n176#1:318\n209#1:319\n209#1:320,2\n211#1:322\n213#1:323,2\n211#1:325\n162#1:306\n162#1:311\n255#1:326\n*E\n"})
public abstract class AbstractSagaDispatcher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Codec codec;
    @NotNull
    private final SagaManager sagaManager;
    @NotNull
    private final Map<SagaState, List<AbstractDispatchFunction<?>>> functions;
    @NotNull
    private static final String DISPATCHED = "dispatched";
    @NotNull
    private static final NotFoundDispatchFunctionException notMatchedSagaHandlerException = new NotFoundDispatchFunctionException("Cannot find matched Saga handler");

    public AbstractSagaDispatcher(@NotNull Codec codec, @NotNull SagaManager sagaManager) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)sagaManager, (String)"sagaManager");
        this.codec = codec;
        this.sagaManager = sagaManager;
        this.functions = new LinkedHashMap();
    }

    @NotNull
    public final Mono<String> dispatch(@NotNull Saga saga2, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)saga2, (String)"saga");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        List<AbstractDispatchFunction<?>> list = this.functions.get((Object)saga2.getState());
        Flux flux = Flux.fromIterable((Iterable)(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList())).flatMap(arg_0 -> AbstractSagaDispatcher.dispatch$lambda$0((Function1)new Function1<AbstractDispatchFunction<?>, Publisher<? extends Object>>(this, saga2){
            final /* synthetic */ AbstractSagaDispatcher this$0;
            final /* synthetic */ Saga $saga;
            {
                this.this$0 = $receiver;
                this.$saga = $saga;
                super(1);
            }

            public final Publisher<? extends Object> invoke(AbstractDispatchFunction<?> function) {
                Mono<?> mono;
                AbstractDispatchFunction<?> abstractDispatchFunction = function;
                if (abstractDispatchFunction instanceof MonoDispatchFunction) {
                    Mono mono2 = AbstractSagaDispatcher.access$mapSagaEvent(this.this$0, Saga.copy$default(this.$saga, null, null, null, null, null, null, 63, null));
                    Intrinsics.checkNotNull(function);
                    mono = LoggingSupportsKt.warningOnError(MonoDispatchFunctionKt.callMono((Mono<SagaEvent>)mono2, (MonoDispatchFunction)function), "Error occurred in SagaHandler function \"" + function.name() + "\" with saga id " + this.$saga.getId());
                } else if (abstractDispatchFunction instanceof NotPublishDispatchFunction) {
                    Mono mono3 = AbstractSagaDispatcher.access$mapSagaEvent(this.this$0, Saga.copy$default(this.$saga, null, null, null, null, null, null, 63, null));
                    Intrinsics.checkNotNull(function);
                    mono = LoggingSupportsKt.warningOnError(NotPublishDispatchFunctionKt.callNotPublish((Mono<SagaEvent>)mono3, (NotPublishDispatchFunction)function), "Error occurred in SagaHandler function \"" + function.name() + "\" with saga id " + this.$saga.getId());
                } else if (abstractDispatchFunction instanceof OrchestrateDispatchFunction) {
                    Mono mono4 = AbstractSagaDispatcher.access$mapSagaEvent(this.this$0, Saga.copy$default(this.$saga, null, null, null, null, null, null, 63, null));
                    Intrinsics.checkNotNull(function);
                    mono = LoggingSupportsKt.warningOnError(OrchestrateDispatchFunctionKt.callOrchestrate((Mono<SagaEvent>)mono4, (OrchestrateDispatchFunction)function), "Error occurred in SagaHandler function \"" + function.name() + "\" with saga id " + this.$saga.getId());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return (Publisher)mono;
            }
        }, arg_0)).subscribeOn(Schedulers.boundedElastic());
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"subscribeOn(...)");
        Mono mono = this.ackWhenComplete(flux, saga2, messageId).then(Mono.just((Object)DISPATCHED));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    private final Flux<?> ackWhenComplete(Flux<?> $this$ackWhenComplete, Saga saga2, String messageId) {
        Flux flux = $this$ackWhenComplete.doOnComplete(() -> AbstractSagaDispatcher.ackWhenComplete$lambda$2(saga2, messageId, this));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnComplete(...)");
        return flux;
    }

    private final Mono<SagaEvent> mapSagaEvent(Saga saga2) {
        Mono mono;
        switch (WhenMappings.$EnumSwitchMapping$0[saga2.getState().ordinal()]) {
            case 1: {
                Mono mono2 = Mono.just((Object)new SagaStartEvent(saga2.getId(), saga2.getServerId(), saga2.getGroup(), this.extractEvent(saga2), this.codec));
                mono = mono2;
                Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"just(...)");
                break;
            }
            case 2: {
                Mono mono3 = Mono.just((Object)new SagaCommitEvent(saga2.getId(), saga2.getServerId(), saga2.getGroup(), this.extractEvent(saga2), this.codec));
                mono = mono3;
                Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"just(...)");
                break;
            }
            case 3: {
                Mono mono4 = Mono.just((Object)new SagaJoinEvent(saga2.getId(), saga2.getServerId(), saga2.getGroup(), this.extractEvent(saga2), this.codec));
                mono = mono4;
                Intrinsics.checkNotNullExpressionValue((Object)mono4, (String)"just(...)");
                break;
            }
            case 4: {
                String string = saga2.getCause();
                if (string == null) {
                    throw new NullPointerException("Null value on SagaRollbackEvent's cause field");
                }
                Mono mono5 = Mono.just((Object)new SagaRollbackEvent(saga2.getId(), saga2.getServerId(), saga2.getGroup(), this.extractEvent(saga2), string, this.codec));
                mono = mono5;
                Intrinsics.checkNotNullExpressionValue((Object)mono5, (String)"just(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mono;
    }

    private final String extractEvent(Saga saga2) {
        String string;
        boolean bl;
        boolean bl2 = bl = saga2.getEvent() != null;
        if (bl) {
            string = saga2.getEvent();
        } else if (!bl) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public final void addOrchestrate$netx(@NotNull Object handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.addOrchestrateFunctions(handler);
        LoggingSupportsKt.info("Add orchestrate fucntion : \"" + handler + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private final void addOrchestrateFunctions(Object handler) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KClasses.getDeclaredMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(handler.getClass()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KFunction it = (KFunction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getReturnType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Mono.class))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List returnTypeMatchedHandlers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = returnTypeMatchedHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            Object element$iv$iv;
            KFunction function = (KFunction)element$iv;
            boolean bl = false;
            element$iv$iv = function.getAnnotations();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                Annotation annotation = (Annotation)element$iv2;
                boolean bl2 = false;
                Object object2 = this;
                try {
                    Boolean bl3;
                    AbstractSagaDispatcher $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244 = object2;
                    boolean bl4 = false;
                    SagaState sagaState = $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.getMatchedSagaState(annotation);
                    KClass<?> eventType = $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.getEventType(annotation);
                    KClass<? extends Throwable>[] noRollbackFor = $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.getNoRollbackFor(annotation);
                    AbstractDispatchFunction.NextSagaState nextState = $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.getNextSagaState(annotation);
                    $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.functions.putIfAbsent(sagaState, new ArrayList());
                    List<AbstractDispatchFunction<?>> list = $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.functions.get((Object)sagaState);
                    if (list != null) {
                        Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type kotlin.reflect.KFunction<reactor.core.publisher.Mono<*>>");
                        bl3 = list.add(new OrchestrateDispatchFunction(eventType, function, handler, noRollbackFor, nextState, $this$addOrchestrateFunctions_u24lambda_u247_u24lambda_u246_u24lambda_u244.sagaManager));
                    } else {
                        bl3 = null;
                    }
                    object = Result.constructor-impl(bl3);
                }
                catch (Throwable bl4) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue;
                Object it = object = throwable;
                boolean bl5 = false;
                throw new IllegalStateException("Cannot add Mono SagaHandler", (Throwable)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostConstruct
    public final void initHandler() {
        List<Object> sagaHandlers = this.findHandlers();
        this.initMonoFunctions(sagaHandlers);
        this.initNotPublisherFunctions(sagaHandlers);
        Map<SagaState, List<AbstractDispatchFunction<?>>> $this$forEach$iv = this.functions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SagaState, List<AbstractDispatchFunction<?>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry<SagaState, List<AbstractDispatchFunction<?>>> element$iv;
            Map.Entry<SagaState, List<AbstractDispatchFunction<?>>> entry = element$iv = iterator.next();
            boolean bl = false;
            List<AbstractDispatchFunction<?>> function = entry.getValue();
            Iterable $this$map$iv = function;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractDispatchFunction abstractDispatchFunction = (AbstractDispatchFunction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.name());
            }
            List functionName = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            LoggingSupportsKt.info("Register functions names : \"" + functionName + "\"");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initMonoFunctions(List<? extends Object> foundHandlers) {
        for (Object object : foundHandlers) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = KClasses.getDeclaredMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(object.getClass()));
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KFunction it = (KFunction)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getReturnType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Mono.class))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List returnTypeMatchedHandlers = (List)destination$iv$iv;
            Iterable $this$forEach$iv = returnTypeMatchedHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Object element$iv$iv;
                KFunction function = (KFunction)element$iv;
                boolean bl = false;
                element$iv$iv = function.getAnnotations();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object2;
                    Annotation annotation = (Annotation)element$iv2;
                    boolean bl2 = false;
                    Object object22 = this;
                    try {
                        Boolean bl3;
                        AbstractSagaDispatcher $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411 = object22;
                        boolean bl4 = false;
                        SagaState sagaState = $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.getMatchedSagaState(annotation);
                        KClass<?> eventType = $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.getEventType(annotation);
                        KClass<? extends Throwable>[] noRollbackFor = $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.getNoRollbackFor(annotation);
                        AbstractDispatchFunction.NextSagaState nextState = $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.getNextSagaState(annotation);
                        $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.functions.putIfAbsent(sagaState, new ArrayList());
                        List<AbstractDispatchFunction<?>> list = $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.functions.get((Object)sagaState);
                        if (list != null) {
                            Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type kotlin.reflect.KFunction<reactor.core.publisher.Mono<*>>");
                            bl3 = list.add(new MonoDispatchFunction(eventType, function, object, noRollbackFor, nextState, $this$initMonoFunctions_u24lambda_u2414_u24lambda_u2413_u24lambda_u2411.sagaManager));
                        } else {
                            bl3 = null;
                        }
                        object2 = Result.constructor-impl(bl3);
                    }
                    catch (Throwable bl4) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                    }
                    object22 = object2;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object22);
                    if (throwable == null) continue;
                    Object it = object2 = throwable;
                    boolean bl5 = false;
                    throw new IllegalStateException("Cannot add Mono SagaHandler", (Throwable)it);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initNotPublisherFunctions(List<? extends Object> foundHandlers) {
        for (Object object : foundHandlers) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = KClasses.getDeclaredMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(object.getClass()));
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KFunction it = (KFunction)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getReturnType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Mono.class)) && !Intrinsics.areEqual((Object)it.getReturnType().getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Flux.class)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List returnTypeMatchedHandlers = (List)destination$iv$iv;
            Iterable $this$forEach$iv = returnTypeMatchedHandlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Object element$iv$iv;
                KFunction function = (KFunction)element$iv;
                boolean bl = false;
                element$iv$iv = function.getAnnotations();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object2;
                    Annotation annotation = (Annotation)element$iv2;
                    boolean bl2 = false;
                    Object object22 = this;
                    try {
                        AbstractSagaDispatcher $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416 = object22;
                        boolean bl3 = false;
                        SagaState sagaState = $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.getMatchedSagaState(annotation);
                        KClass<?> eventType = $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.getEventType(annotation);
                        KClass<? extends Throwable>[] noRollbackFor = $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.getNoRollbackFor(annotation);
                        AbstractDispatchFunction.NextSagaState nextState = $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.getNextSagaState(annotation);
                        $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.functions.putIfAbsent(sagaState, new ArrayList());
                        List<AbstractDispatchFunction<?>> list = $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.functions.get((Object)sagaState);
                        object2 = Result.constructor-impl(list != null ? Boolean.valueOf(list.add(new NotPublishDispatchFunction(eventType, function, object, noRollbackFor, nextState, $this$initNotPublisherFunctions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2416.sagaManager))) : null);
                    }
                    catch (Throwable bl3) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object22 = object2;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object22);
                    if (throwable == null) continue;
                    Object it = object2 = throwable;
                    boolean bl4 = false;
                    throw new IllegalStateException("Cannot add SagaHandler", (Throwable)it);
                }
            }
        }
    }

    @NotNull
    protected abstract List<Object> findHandlers();

    private final KClass<?> getEventType(Annotation annotation) {
        KClass kClass;
        Annotation annotation2 = annotation;
        if (annotation2 instanceof SagaStartListener) {
            kClass = Reflection.getOrCreateKotlinClass(((SagaStartListener)annotation).event());
        } else if (annotation2 instanceof SagaCommitListener) {
            kClass = Reflection.getOrCreateKotlinClass(((SagaCommitListener)annotation).event());
        } else if (annotation2 instanceof SagaJoinListener) {
            kClass = Reflection.getOrCreateKotlinClass(((SagaJoinListener)annotation).event());
        } else if (annotation2 instanceof SagaRollbackListener) {
            kClass = Reflection.getOrCreateKotlinClass(((SagaRollbackListener)annotation).event());
        } else {
            throw notMatchedSagaHandlerException;
        }
        return kClass;
    }

    private final KClass<? extends Throwable>[] getNoRollbackFor(Annotation annotation) {
        KClass[] kClassArray;
        Annotation annotation2 = annotation;
        if (annotation2 instanceof SagaStartListener) {
            kClassArray = Reflection.getOrCreateKotlinClasses((Class[])((SagaStartListener)annotation).noRollbackFor());
        } else if (annotation2 instanceof SagaCommitListener) {
            kClassArray = Reflection.getOrCreateKotlinClasses((Class[])((SagaCommitListener)annotation).noRollbackFor());
        } else if (annotation2 instanceof SagaJoinListener) {
            kClassArray = Reflection.getOrCreateKotlinClasses((Class[])((SagaJoinListener)annotation).noRollbackFor());
        } else if (annotation2 instanceof SagaRollbackListener) {
            boolean $i$f$emptyArray = false;
            kClassArray = new KClass[]{};
        } else {
            throw notMatchedSagaHandlerException;
        }
        return kClassArray;
    }

    private final SagaState getMatchedSagaState(Annotation annotation) {
        SagaState sagaState;
        Annotation annotation2 = annotation;
        if (annotation2 instanceof SagaStartListener) {
            sagaState = SagaState.START;
        } else if (annotation2 instanceof SagaCommitListener) {
            sagaState = SagaState.COMMIT;
        } else if (annotation2 instanceof SagaJoinListener) {
            sagaState = SagaState.JOIN;
        } else if (annotation2 instanceof SagaRollbackListener) {
            sagaState = SagaState.ROLLBACK;
        } else {
            throw notMatchedSagaHandlerException;
        }
        return sagaState;
    }

    private final AbstractDispatchFunction.NextSagaState getNextSagaState(Annotation annotation) {
        Annotation annotation2 = annotation;
        return annotation2 instanceof SagaStartListener ? this.toNextSagaState(((SagaStartListener)annotation).successWith()) : (annotation2 instanceof SagaJoinListener ? this.toNextSagaState(((SagaJoinListener)annotation).successWith()) : AbstractDispatchFunction.NextSagaState.END);
    }

    private final AbstractDispatchFunction.NextSagaState toNextSagaState(SuccessWith $this$toNextSagaState) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toNextSagaState.ordinal()]) {
            case 1 -> AbstractDispatchFunction.NextSagaState.JOIN;
            case 2 -> AbstractDispatchFunction.NextSagaState.COMMIT;
            case 3 -> AbstractDispatchFunction.NextSagaState.END;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    protected abstract Mono<Pair<Saga, String>> ack(@NotNull Saga var1, @NotNull String var2);

    private static final Publisher dispatch$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono ackWhenComplete$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void ackWhenComplete$lambda$2(Saga $saga, String $messageId, AbstractSagaDispatcher this$0) {
        Intrinsics.checkNotNullParameter((Object)$saga, (String)"$saga");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Mono mono = Mono.just((Object)TuplesKt.to((Object)$saga, (Object)$messageId));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        LoggingSupportsKt.info(mono, "Ack saga \"" + $saga.getId() + "\"").flatMap(arg_0 -> AbstractSagaDispatcher.ackWhenComplete$lambda$2$lambda$1((Function1)new Function1<Pair<? extends Saga, ? extends String>, Mono<? extends Pair<? extends Saga, ? extends String>>>(this$0, $saga, $messageId){
            final /* synthetic */ AbstractSagaDispatcher this$0;
            final /* synthetic */ Saga $saga;
            final /* synthetic */ String $messageId;
            {
                this.this$0 = $receiver;
                this.$saga = $saga;
                this.$messageId = $messageId;
                super(1);
            }

            public final Mono<? extends Pair<Saga, String>> invoke(Pair<Saga, String> it) {
                return LoggingSupportsKt.warningOnError(this.this$0.ack(this.$saga, this.$messageId), "Fail to ack saga \"" + this.$saga.getId() + "\"");
            }
        }, arg_0)).subscribeOn(Schedulers.parallel()).subscribe();
    }

    public static final /* synthetic */ Mono access$mapSagaEvent(AbstractSagaDispatcher $this, Saga saga2) {
        return $this.mapSagaEvent(saga2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rooftop/netx/engine/AbstractSagaDispatcher$Companion;", "", "()V", "DISPATCHED", "", "notMatchedSagaHandlerException", "Lorg/rooftop/netx/api/NotFoundDispatchFunctionException;", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SagaState.values().length];
            try {
                nArray[SagaState.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SagaState.COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SagaState.JOIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SagaState.ROLLBACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SuccessWith.values().length];
            try {
                nArray[SuccessWith.PUBLISH_JOIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuccessWith.PUBLISH_COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuccessWith.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

