/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.api;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rooftop.netx.api.ResultException;
import org.rooftop.netx.api.TypeReference;
import org.rooftop.netx.core.Codec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001a*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u001a\u001bB-\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\r\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\r\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\r\u001a\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0016\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0016\u001a\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/rooftop/netx/api/Result;", "T", "", "isSuccess", "", "codec", "Lorg/rooftop/netx/core/Codec;", "result", "", "error", "Lorg/rooftop/netx/api/Result$Error;", "(ZLorg/rooftop/netx/core/Codec;Ljava/lang/String;Lorg/rooftop/netx/api/Result$Error;)V", "()Z", "decodeResult", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "typeReference", "Lorg/rooftop/netx/api/TypeReference;", "(Lorg/rooftop/netx/api/TypeReference;)Ljava/lang/Object;", "decodeResultOrThrow", "throwError", "", "toString", "Companion", "Error", "netx"})
public final class Result<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isSuccess;
    @NotNull
    private final Codec codec;
    @Nullable
    private final String result;
    @Nullable
    private final Error error;

    private Result(boolean isSuccess, Codec codec, String result, Error error) {
        this.isSuccess = isSuccess;
        this.codec = codec;
        this.result = result;
        this.error = error;
    }

    /* synthetic */ Result(boolean bl, Codec codec, String string, Error error, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            error = null;
        }
        this(bl, codec, string, error);
    }

    public final boolean isSuccess() {
        return this.isSuccess;
    }

    @NotNull
    public final T decodeResultOrThrow(@NotNull TypeReference<T> typeReference) {
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        return this.decodeResult(typeReference);
    }

    @NotNull
    public final T decodeResultOrThrow(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.decodeResultOrThrow(JvmClassMappingKt.getKotlinClass(type));
    }

    @NotNull
    public final T decodeResultOrThrow(@NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!this.isSuccess) {
            this.throwError();
        }
        return this.decodeResult(type);
    }

    @NotNull
    public final T decodeResult(@NotNull TypeReference<T> typeReference) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
                string = this.result;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                T t = this.codec.decode(it, typeReference);
                string = t;
                if (t != null) break block3;
            }
            throw new ResultException("Cannot decode result cause Result is fail state");
        }
        return (T)string;
    }

    @NotNull
    public final T decodeResult(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.decodeResult(JvmClassMappingKt.getKotlinClass(type));
    }

    @NotNull
    public final T decodeResult(@NotNull KClass<T> type) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                string = this.result;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                T t = this.codec.decode(it, type);
                string = t;
                if (t != null) break block3;
            }
            throw new ResultException("Cannot decode result cause Result is fail state");
        }
        return (T)string;
    }

    public final void throwError() {
        Unit unit;
        Error error = this.error;
        if (error != null) {
            error.throwError(this.codec);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ResultException("Cannot throw error cause Result is success state");
        }
    }

    @NotNull
    public String toString() {
        return "Result(isSuccess=" + this.isSuccess + ", codec=" + this.codec + ", result=" + this.result + ", error=" + this.error + ")";
    }

    public /* synthetic */ Result(boolean isSuccess, Codec codec, String result, Error error, DefaultConstructorMarker $constructor_marker) {
        this(isSuccess, codec, result, error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ&\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/rooftop/netx/api/Result$Companion;", "", "()V", "fail", "Lorg/rooftop/netx/api/Result;", "T", "codec", "Lorg/rooftop/netx/core/Codec;", "error", "", "type", "Lkotlin/reflect/KClass;", "", "success", "result", "netx"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Result<T> success(@NotNull Codec codec, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return new Result(true, codec, result, null, null);
        }

        @NotNull
        public final <T> Result<T> fail(@NotNull Codec codec, @NotNull String error, @NotNull KClass<Throwable> type) {
            Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            return new Result(false, codec, null, new Error(error, type), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rooftop/netx/api/Result$Error;", "", "error", "", "type", "Lkotlin/reflect/KClass;", "", "(Ljava/lang/String;Lkotlin/reflect/KClass;)V", "throwError", "", "codec", "Lorg/rooftop/netx/core/Codec;", "toString", "netx"})
    private static final class Error {
        @NotNull
        private final String error;
        @NotNull
        private final KClass<Throwable> type;

        public Error(@NotNull String error, @NotNull KClass<Throwable> type) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.error = error;
            this.type = type;
        }

        public final void throwError(@NotNull Codec codec) {
            Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
            throw codec.decode(this.error, this.type);
        }

        @NotNull
        public String toString() {
            return "Error(error='" + this.error + "', type=" + this.type + ")";
        }
    }
}

