/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer.postprocess;

import java.util.List;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.data.PropertyGroup;
import org.rodnansol.core.generator.writer.postprocess.PostProcessPropertyGroupsCommand;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnknownGroupRenamePostProcessor
implements PropertyGroupPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnknownGroupRenamePostProcessor.class);

    UnknownGroupRenamePostProcessor() {
    }

    @Override
    public void postProcess(PostProcessPropertyGroupsCommand command) {
        String unknownGroupLocalization;
        List<PropertyGroup> propertyGroups = command.getPropertyGroups();
        TemplateCustomization templateCustomization = command.getTemplateCustomization();
        if (templateCustomization != null && !"Unknown group".equals(unknownGroupLocalization = templateCustomization.getUnknownGroupLocalization())) {
            LOGGER.debug("Renaming unknown group to:[{}]", (Object)unknownGroupLocalization);
            if (propertyGroups != null) {
                propertyGroups.stream().filter(PropertyGroup::isUnknownGroup).forEach(group -> group.setGroupName(unknownGroupLocalization));
            }
        }
    }
}

