/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer.postprocess;

import java.util.List;
import org.rodnansol.core.generator.writer.postprocess.EmptyGroupRemovalPostProcessor;
import org.rodnansol.core.generator.writer.postprocess.IncludeExcludeGroupPostProcessor;
import org.rodnansol.core.generator.writer.postprocess.IncludeExcludePropertyPostProcessor;
import org.rodnansol.core.generator.writer.postprocess.PostProcessPropertyGroupsCommand;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupPostProcessor;
import org.rodnansol.core.generator.writer.postprocess.UnknownGroupRemovalPostProcessor;
import org.rodnansol.core.generator.writer.postprocess.UnknownGroupRenamePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyGroupFilterService {
    public static final PropertyGroupFilterService INSTANCE = new PropertyGroupFilterService();
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyGroupFilterService.class);
    private final List<PropertyGroupPostProcessor> propertyGroupPostProcessors;

    public PropertyGroupFilterService(List<PropertyGroupPostProcessor> propertyGroupPostProcessors) {
        this.propertyGroupPostProcessors = propertyGroupPostProcessors;
    }

    public PropertyGroupFilterService() {
        this(List.of(new UnknownGroupRemovalPostProcessor(), new IncludeExcludeGroupPostProcessor(), new IncludeExcludePropertyPostProcessor(), new EmptyGroupRemovalPostProcessor(), new UnknownGroupRenamePostProcessor()));
    }

    public void postProcessPropertyGroups(PostProcessPropertyGroupsCommand command) {
        try {
            LOGGER.debug("Running post processors with the following command:[{}] - List of post processors:[{}]", (Object)command, this.propertyGroupPostProcessors);
            this.propertyGroupPostProcessors.forEach(propertyGroupPostProcessor -> propertyGroupPostProcessor.postProcess(command));
        }
        catch (Exception e) {
            LOGGER.warn("Error during filtering the property groups and properties, no filtering logic will be applied, please check the logs.", (Throwable)e);
        }
    }
}

