/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.compiler.TemplateCompiler;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.data.MainTemplateData;
import org.rodnansol.core.generator.template.data.PropertyGroup;
import org.rodnansol.core.generator.writer.CreateDocumentCommand;
import org.rodnansol.core.generator.writer.postprocess.PostProcessPropertyGroupsCommand;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupFilterService;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Documenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Documenter.class);
    private final MetadataReader metadataReader;
    private final TemplateCompiler templateCompiler;
    private final MetadataInputResolverContext metadataInputResolverContext;
    private final PropertyGroupFilterService propertyGroupFilterService;

    public Documenter(MetadataReader metadataReader, TemplateCompiler templateCompiler, MetadataInputResolverContext metadataInputResolverContext, PropertyGroupFilterService propertyGroupFilterService) {
        this.metadataReader = metadataReader;
        this.templateCompiler = templateCompiler;
        this.metadataInputResolverContext = metadataInputResolverContext;
        this.propertyGroupFilterService = propertyGroupFilterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMetadataAndGenerateRenderedFile(CreateDocumentCommand createDocumentCommand) throws IOException {
        try {
            LOGGER.debug("Creating document with command:[{}]", (Object)createDocumentCommand);
            MainTemplateData mainTemplateData = this.createTemplateData(createDocumentCommand);
            this.setupMemoryStore(mainTemplateData);
            String content = this.templateCompiler.compileTemplate(createDocumentCommand.getTemplate(), mainTemplateData);
            try (FileWriter fileWriter = new FileWriter(CoreFileUtils.initializeFileWithPath(createDocumentCommand.getOutput()));){
                LOGGER.debug("Writing generated content to file:[{}]", (Object)createDocumentCommand.getOutput());
                fileWriter.write(content);
            }
        }
        finally {
            this.templateCompiler.getMemoryStore().resetMemory();
        }
    }

    private void setupMemoryStore(MainTemplateData mainTemplateData) {
        this.templateCompiler.getMemoryStore().addItemToMemory("templateCustomization", mainTemplateData.getTemplateCustomization());
    }

    private MainTemplateData createTemplateData(CreateDocumentCommand createDocumentCommand) throws IOException {
        try (InputStream inputStream = this.metadataInputResolverContext.getInputStreamFromFile(createDocumentCommand.getProject(), createDocumentCommand.getMetadataInput());){
            List<PropertyGroup> propertyGroups = this.metadataReader.readPropertiesAsPropertyGroupList(inputStream);
            TemplateCustomization templateCustomization = createDocumentCommand.getTemplateCustomization();
            this.filterGroupsAndProperties(createDocumentCommand, propertyGroups, templateCustomization);
            MainTemplateData mainTemplateData = MainTemplateData.ofMainSection(createDocumentCommand.getName(), propertyGroups);
            mainTemplateData.setGenerationDate(LocalDateTime.now());
            mainTemplateData.setMainDescription(createDocumentCommand.getDescription());
            mainTemplateData.setTemplateCustomization(templateCustomization);
            MainTemplateData mainTemplateData2 = mainTemplateData;
            return mainTemplateData2;
        }
    }

    private void filterGroupsAndProperties(CreateDocumentCommand createDocumentCommand, List<PropertyGroup> propertyGroups, TemplateCustomization templateCustomization) {
        this.propertyGroupFilterService.postProcessPropertyGroups(new PostProcessPropertyGroupsCommand(templateCustomization, propertyGroups, createDocumentCommand.getExcludedGroups(), createDocumentCommand.getIncludedGroups(), createDocumentCommand.getExcludedProperties(), createDocumentCommand.getIncludedProperties()));
    }
}

