/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer;

import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.lang3.tuple.ImmutablePair;
import com.github.jknack.handlebars.internal.lang3.tuple.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.template.compiler.TemplateCompiler;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.data.MainTemplateData;
import org.rodnansol.core.generator.template.data.PropertyGroup;
import org.rodnansol.core.generator.template.data.SubTemplateData;
import org.rodnansol.core.generator.template.data.TemplateData;
import org.rodnansol.core.generator.writer.CombinedInput;
import org.rodnansol.core.generator.writer.CreateAggregationCommand;
import org.rodnansol.core.generator.writer.CustomTemplate;
import org.rodnansol.core.generator.writer.postprocess.PostProcessPropertyGroupsCommand;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupFilterService;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationDocumenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationDocumenter.class);
    private final MetadataReader metadataReader;
    private final TemplateCompiler templateCompiler;
    private final MetadataInputResolverContext metadataInputResolverContext;
    private final PropertyGroupFilterService propertyGroupFilterService;

    public AggregationDocumenter(MetadataReader metadataReader, TemplateCompiler templateCompiler, MetadataInputResolverContext metadataInputResolverContext, PropertyGroupFilterService propertyGroupFilterService) {
        this.metadataReader = metadataReader;
        this.templateCompiler = templateCompiler;
        this.metadataInputResolverContext = metadataInputResolverContext;
        this.propertyGroupFilterService = propertyGroupFilterService;
    }

    public void createDocumentsAndAggregate(CreateAggregationCommand createAggregationCommand) {
        Objects.requireNonNull(createAggregationCommand, "createAggregationCommand is NULL");
        LOGGER.info("Creating documents and aggregating them based on the incoming command:[{}]", (Object)createAggregationCommand);
        Pair<List<SubTemplateData>, List<PropertyGroup>> result = this.createSubTemplateDataAndPropertyGroupList(createAggregationCommand);
        try {
            this.templateCompiler.getMemoryStore().addItemToMemory("templateCustomization", createAggregationCommand.getTemplateCustomization());
            this.createAndWriteContent(createAggregationCommand, (List)result.getLeft(), (List)result.getRight());
        }
        finally {
            this.templateCompiler.getMemoryStore().resetMemory();
        }
    }

    private Pair<List<SubTemplateData>, List<PropertyGroup>> createSubTemplateDataAndPropertyGroupList(CreateAggregationCommand createAggregationCommand) {
        ArrayList<SubTemplateData> subTemplateDataList = new ArrayList<SubTemplateData>(createAggregationCommand.getCombinedInputs().size());
        ArrayList<PropertyGroup> propertyGroups = new ArrayList<PropertyGroup>(createAggregationCommand.getCombinedInputs().size());
        for (CombinedInput entry : createAggregationCommand.getCombinedInputs()) {
            LOGGER.info("Processing entry:[{}]", (Object)entry);
            try {
                InputStream inputStream = this.metadataInputResolverContext.getInputStreamFromFile(createAggregationCommand.getProject(), entry.getInput());
                try {
                    List<PropertyGroup> groups = this.metadataReader.readPropertiesAsPropertyGroupList(inputStream);
                    this.filterGroupsAndProperties(createAggregationCommand.getTemplateCustomization(), entry, groups);
                    propertyGroups.addAll(groups);
                    subTemplateDataList.add(this.createModuleTemplateData(createAggregationCommand.getTemplateCustomization(), entry.getSectionName(), groups, entry.getDescription()));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error during reading an entry:[" + entry.getInput() + "]", (Throwable)e);
            }
        }
        return new ImmutablePair(subTemplateDataList, propertyGroups);
    }

    void filterGroupsAndProperties(TemplateCustomization templateCustomization, CombinedInput entry, List<PropertyGroup> groups) {
        this.propertyGroupFilterService.postProcessPropertyGroups(new PostProcessPropertyGroupsCommand(templateCustomization, groups, entry.getExcludedGroups(), entry.getIncludedGroups(), entry.getExcludedProperties(), entry.getIncludedProperties()));
    }

    private void createAndWriteContent(CreateAggregationCommand createAggregationCommand, List<SubTemplateData> subTemplateDataList, List<PropertyGroup> propertyGroups) {
        MainTemplateData mainTemplateData = this.createMainTemplateData(createAggregationCommand, propertyGroups);
        mainTemplateData.setSubTemplateDataList(subTemplateDataList);
        ResolvedTemplate resolvedTemplate = new ResolvedTemplate(createAggregationCommand);
        ImmutablePair<String, String> renderedHeaderAndFooter = this.renderHeaderAndFooter(resolvedTemplate, mainTemplateData);
        String aggregatedContent = this.renderContent(resolvedTemplate, subTemplateDataList);
        this.writeRenderedSectionsToFile(createAggregationCommand, renderedHeaderAndFooter, aggregatedContent);
    }

    private ImmutablePair<String, String> renderHeaderAndFooter(ResolvedTemplate resolvedTemplate, MainTemplateData mainTemplateData) {
        String header = this.templateCompiler.compileTemplate(resolvedTemplate.getHeaderTemplate(), mainTemplateData);
        String footer = this.templateCompiler.compileTemplate(resolvedTemplate.getFooterTemplate(), mainTemplateData);
        return new ImmutablePair((Object)header, (Object)footer);
    }

    private String renderContent(ResolvedTemplate resolvedTemplate, List<SubTemplateData> subTemplateDataList) {
        return subTemplateDataList.stream().map(templateData -> this.templateCompiler.compileTemplate(resolvedTemplate.getContentTemplate(), (TemplateData)templateData)).reduce("", String::concat);
    }

    private void writeRenderedSectionsToFile(CreateAggregationCommand createAggregationCommand, ImmutablePair<String, String> renderedHeaderAndFooter, String aggregatedContent) {
        try (FileWriter fileWriter = new FileWriter(CoreFileUtils.initializeFileWithPath(createAggregationCommand.getOutput()));){
            LOGGER.debug("Writing aggregated content to file:[{}]", (Object)createAggregationCommand.getOutput());
            fileWriter.append((CharSequence)renderedHeaderAndFooter.getLeft()).append(aggregatedContent).append((CharSequence)renderedHeaderAndFooter.getRight());
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Error during writing content to file...", e);
        }
    }

    private SubTemplateData createModuleTemplateData(TemplateCustomization templateCustomization, String sectionName, List<PropertyGroup> propertyGroups, String moduleDescription) {
        SubTemplateData subTemplateData = new SubTemplateData(sectionName, propertyGroups);
        subTemplateData.setTemplateCustomization(templateCustomization);
        subTemplateData.setGenerationDate(LocalDateTime.now());
        subTemplateData.setModuleDescription(moduleDescription);
        return subTemplateData;
    }

    private MainTemplateData createMainTemplateData(CreateAggregationCommand createAggregationCommand, List<PropertyGroup> propertyGroups) {
        MainTemplateData mainTemplateData = new MainTemplateData(createAggregationCommand.getAggregatedDocumentHeader(), propertyGroups);
        mainTemplateData.setMainDescription(createAggregationCommand.getDescription());
        mainTemplateData.setGenerationDate(LocalDateTime.now());
        mainTemplateData.setTemplateCustomization(createAggregationCommand.getTemplateCustomization());
        return mainTemplateData;
    }

    static class ResolvedTemplate {
        private final String headerTemplate;
        private final String contentTemplate;
        private final String footerTemplate;

        public ResolvedTemplate(CreateAggregationCommand createAggregationCommand) {
            Optional<CustomTemplate> optionalCustomTemplate = Optional.ofNullable(createAggregationCommand.getCustomTemplate());
            TemplateCustomization templateCustomization = createAggregationCommand.getTemplateCustomization();
            TemplateType templateType = createAggregationCommand.getTemplateType();
            this.headerTemplate = optionalCustomTemplate.map(CustomTemplate::getCustomHeaderTemplate).filter(StringUtils::isNotBlank).orElseGet(() -> templateType.getHeaderTemplate(templateCustomization.getTemplateMode()));
            this.footerTemplate = optionalCustomTemplate.map(CustomTemplate::getCustomFooterTemplate).filter(StringUtils::isNotBlank).orElseGet(() -> templateType.getFooterTemplate(templateCustomization.getTemplateMode()));
            this.contentTemplate = optionalCustomTemplate.map(CustomTemplate::getCustomContentTemplate).filter(StringUtils::isNotBlank).orElseGet(() -> templateType.getContentTemplate(createAggregationCommand.getTemplateCustomization().getTemplateMode()));
        }

        public String getHeaderTemplate() {
            return this.headerTemplate;
        }

        public String getContentTemplate() {
            return this.contentTemplate;
        }

        public String getFooterTemplate() {
            return this.footerTemplate;
        }
    }
}

