/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.template.compiler.TemplateCompiler;
import org.rodnansol.core.generator.template.compiler.ThreadLocalTemplateCompilerStore;
import org.rodnansol.core.generator.template.data.TemplateData;
import org.rodnansol.core.generator.template.handlebars.EnvironmentVariableHelper;
import org.rodnansol.core.generator.template.handlebars.IsCompactModeHelper;
import org.rodnansol.core.generator.template.handlebars.IsIncludedHelper;
import org.rodnansol.core.generator.template.handlebars.WorkingDirectoryAwareRecursiveFileTemplateLoader;
import org.rodnansol.core.generator.template.handlebars.WorkingDirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsTemplateCompiler
implements TemplateCompiler {
    public static final TemplateCompiler INSTANCE = new HandlebarsTemplateCompiler();
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlebarsTemplateCompiler.class);
    private static final String HELPER_AS_ENV = "as_env";
    private static final String HELPER_IS_INCLUDED = "is_included";
    private static final String HELPER_IS_COMPACT_MODE = "is_compact_mode";
    private final Handlebars handlebars;
    private final I18nHelper i18nHelper;

    public HandlebarsTemplateCompiler(Handlebars handlebars, I18nHelper i18nHelper) {
        this.handlebars = handlebars;
        this.i18nHelper = i18nHelper;
    }

    public HandlebarsTemplateCompiler() {
        this(HandlebarsTemplateCompiler.createDefaultHandlebarsInstance(), I18nHelper.i18n);
    }

    private static Handlebars createDefaultHandlebarsInstance() {
        return new Handlebars().registerHelper(HELPER_AS_ENV, (Helper)new EnvironmentVariableHelper()).registerHelper(HELPER_IS_INCLUDED, (Helper)new IsIncludedHelper(ThreadLocalTemplateCompilerStore.INSTANCE)).registerHelper(HELPER_IS_COMPACT_MODE, (Helper)new IsCompactModeHelper(ThreadLocalTemplateCompilerStore.INSTANCE)).with(new TemplateLoader[]{new ClassPathTemplateLoader(), new WorkingDirectoryAwareRecursiveFileTemplateLoader(".", WorkingDirectoryProvider.INSTANCE)});
    }

    @Override
    public String compileTemplate(String templatePath, TemplateData templateData) throws DocumentGenerationException {
        LOGGER.debug("Compiling template:[{}] with data:[{}]", (Object)templatePath, (Object)templatePath);
        Objects.requireNonNull(templatePath, "templatePath is NULL");
        Objects.requireNonNull(templateData, "templateData is NULL");
        try {
            this.setLocalizationIfPossible(templateData);
            return this.handlebars.compile(templatePath).apply((Object)templateData);
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Error during compiling the template with Handlebars engine", e);
        }
    }

    private void setLocalizationIfPossible(TemplateData templateData) {
        try {
            if (templateData.getTemplateCustomization() != null && templateData.getTemplateCustomization().getLocale() != null) {
                String locale = templateData.getTemplateCustomization().getLocale();
                LOGGER.debug("Setting locale to: [{}]", (Object)locale);
                this.i18nHelper.setDefaultLocale(Locale.forLanguageTag(locale));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during setting the Localization for the documents, please check the logs for more information.");
        }
    }
}

