/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.data.Property;
import org.rodnansol.core.generator.template.data.PropertyGroup;
import org.rodnansol.core.generator.template.data.TemplateData;

public class SubTemplateData
implements TemplateData {
    private final String moduleName;
    private final List<PropertyGroup> propertyGroups;
    private String moduleDescription;
    private LocalDateTime generationDate;
    private TemplateCustomization templateCustomization;

    public SubTemplateData(String moduleName, List<PropertyGroup> propertyGroups) {
        this.moduleName = moduleName;
        this.propertyGroups = Objects.requireNonNull(propertyGroups, "propertyGroups is NULL");
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public String getModuleDescription() {
        return this.moduleDescription;
    }

    public void setModuleDescription(String moduleDescription) {
        this.moduleDescription = moduleDescription;
    }

    public LocalDateTime getGenerationDate() {
        return this.generationDate;
    }

    public void setGenerationDate(LocalDateTime generationDate) {
        this.generationDate = generationDate;
    }

    @Override
    public TemplateCustomization getTemplateCustomization() {
        return this.templateCustomization;
    }

    @Override
    public void setTemplateCustomization(TemplateCustomization templateCustomization) {
        this.templateCustomization = templateCustomization;
    }

    @Override
    public List<Property> getAggregatedProperties() {
        return this.propertyGroups.stream().flatMap(groups -> groups.getProperties().stream()).collect(Collectors.toList());
    }

    public String toString() {
        return "SubTemplateData{moduleName='" + this.moduleName + "', propertyGroups=" + this.propertyGroups + ", moduleDescription='" + this.moduleDescription + "', generationDate=" + this.generationDate + "}";
    }
}

