/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.customization;

import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.template.customization.AsciiDocTemplateCustomization;
import org.rodnansol.core.generator.template.customization.HtmlTemplateCustomization;
import org.rodnansol.core.generator.template.customization.MarkdownTemplateCustomization;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.customization.XmlTemplateCustomization;

public class TemplateCustomizationFactory {
    private TemplateCustomizationFactory() {
    }

    public static TemplateCustomization getDefaultTemplateCustomizationByType(TemplateType templateType) {
        switch (templateType) {
            case MARKDOWN: {
                return new MarkdownTemplateCustomization();
            }
            case ADOC: {
                return new AsciiDocTemplateCustomization();
            }
            case HTML: {
                return new HtmlTemplateCustomization();
            }
            case XML: {
                return new XmlTemplateCustomization();
            }
        }
        throw new IllegalArgumentException("Unknown template type.");
    }
}

