/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.compiler;

import java.util.HashMap;
import java.util.Map;
import org.rodnansol.core.generator.template.compiler.TemplateCompilerMemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalTemplateCompilerStore
implements TemplateCompilerMemoryStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(ThreadLocalTemplateCompilerStore.class);
    public static final ThreadLocalTemplateCompilerStore INSTANCE = new ThreadLocalTemplateCompilerStore();
    private static final ThreadLocal<Map<String, Object>> STORE = ThreadLocal.withInitial(HashMap::new);

    private ThreadLocalTemplateCompilerStore() {
    }

    @Override
    public void addItemToMemory(String key, Object value) {
        LOGGER.debug("Adding item to memory store with key:[{}] and value:[{}]", (Object)key, value);
        STORE.get().put(key, value);
    }

    @Override
    public <T> T getItem(String key) {
        LOGGER.debug("Accessing value with key:[{}]", (Object)key);
        return (T)STORE.get().get(key);
    }

    @Override
    public void resetMemory() {
        LOGGER.debug("Resetting memory store.");
        STORE.remove();
    }
}

