/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.compiler;

import java.util.ServiceLoader;
import org.rodnansol.core.generator.template.compiler.TemplateCompiler;
import org.rodnansol.core.generator.template.handlebars.HandlebarsTemplateCompiler;

public class TemplateCompilerFactory {
    private TemplateCompilerFactory() {
    }

    public static TemplateCompiler getInstance(String templateCompilerName) {
        ServiceLoader<TemplateCompiler> load = ServiceLoader.load(TemplateCompiler.class);
        return (TemplateCompiler)load.stream().filter(templateCompilerProvider -> templateCompilerProvider.type().getName().equals(templateCompilerName)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find TemplateCompiler implementation with name:[" + templateCompilerName + "]")).get();
    }

    public static TemplateCompiler getInstanceByClassName(String className) {
        try {
            return (TemplateCompiler)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to construct class:[" + className + "]", e);
        }
    }

    public static TemplateCompiler getDefaultCompiler() {
        return HandlebarsTemplateCompiler.INSTANCE;
    }

    public static String getDefaultCompilerName() {
        return TemplateCompilerFactory.getDefaultCompiler().getClass().getName();
    }
}

