/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template;

import java.util.Map;
import java.util.Optional;
import org.rodnansol.core.generator.template.TemplateMode;
import org.rodnansol.core.generator.template.TemplateNotFoundException;
import org.rodnansol.core.generator.template.TemplateResource;

public enum TemplateType {
    MARKDOWN(".md", Map.of(TemplateMode.STANDARD, new TemplateResource("templates/aggregated/md/header.md", "templates/partials/md/content.md", "templates/aggregated/md/footer.md", "templates/single/single-document-template.md"), TemplateMode.COMPACT, new TemplateResource("templates/aggregated/md/compact-header.md", "templates/partials/md/compact-content.md", "templates/aggregated/md/compact-footer.md", "templates/single/compact-single-document-template.md"))),
    ADOC(".adoc", Map.of(TemplateMode.STANDARD, new TemplateResource("templates/aggregated/adoc/header.adoc", "templates/partials/adoc/content.adoc", "templates/aggregated/adoc/footer.adoc", "templates/single/single-document-template.adoc"), TemplateMode.COMPACT, new TemplateResource("templates/aggregated/adoc/compact-header.adoc", "templates/partials/adoc/compact-content.adoc", "templates/aggregated/adoc/compact-footer.adoc", "templates/single/compact-single-document-template.adoc"))),
    HTML(".html", Map.of(TemplateMode.STANDARD, new TemplateResource("templates/aggregated/html/header.html", "templates/partials/html/content.html", "templates/aggregated/html/footer.html", "templates/single/single-document-template.html"), TemplateMode.COMPACT, new TemplateResource("templates/aggregated/html/compact-header.html", "templates/partials/html/compact-content.html", "templates/aggregated/html/compact-footer.html", "templates/single/compact-single-document-template.html"))),
    XML(".xml", Map.of(TemplateMode.STANDARD, new TemplateResource("templates/aggregated/xml/header.xml", "templates/partials/xml/content.xml", "templates/aggregated/xml/footer.xml", "templates/single/single-document-template.xml")));

    private final String extension;
    private final Map<TemplateMode, TemplateResource> templateResourcesMap;

    private TemplateType(String extension, Map<TemplateMode, TemplateResource> templateResourcesMap) {
        this.extension = extension;
        this.templateResourcesMap = templateResourcesMap;
    }

    public String getSingleTemplate(TemplateMode templateMode) {
        return Optional.ofNullable(this.templateResourcesMap.get((Object)templateMode)).map(TemplateResource::getCombinedTemplate).orElseThrow(() -> new TemplateNotFoundException("Header template for type is not found:[" + templateMode + "]"));
    }

    public String getExtension() {
        return this.extension;
    }

    public String getHeaderTemplate(TemplateMode templateMode) {
        return Optional.ofNullable(this.templateResourcesMap.get((Object)templateMode)).map(TemplateResource::getHeaderTemplate).orElseThrow(() -> new TemplateNotFoundException("Header template for type is not found:[" + templateMode + "]"));
    }

    public String getContentTemplate(TemplateMode templateMode) {
        return Optional.ofNullable(this.templateResourcesMap.get((Object)templateMode)).map(TemplateResource::getContentTemplate).orElseThrow(() -> new TemplateNotFoundException("Content template for type is not found:[" + templateMode + "]"));
    }

    public String getFooterTemplate(TemplateMode templateMode) {
        return Optional.ofNullable(this.templateResourcesMap.get((Object)templateMode)).map(TemplateResource::getFooterTemplate).orElseThrow(() -> new TemplateNotFoundException("Footer template for type is not found:[" + templateMode + "]"));
    }

    static class StandardTemplates {
        StandardTemplates() {
        }

        static class FooterTemplateConstants {
            static final String ADOC = "templates/aggregated/adoc/footer.adoc";
            static final String MARKDOWN = "templates/aggregated/md/footer.md";
            static final String HTML = "templates/aggregated/html/footer.html";
            static final String XML = "templates/aggregated/xml/footer.xml";

            FooterTemplateConstants() {
            }
        }

        static class ContentTemplateConstants {
            static final String ADOC = "templates/partials/adoc/content.adoc";
            static final String MARKDOWN = "templates/partials/md/content.md";
            static final String HTML = "templates/partials/html/content.html";
            static final String XML = "templates/partials/xml/content.xml";

            ContentTemplateConstants() {
            }
        }

        static class HeaderTemplateConstants {
            static final String ADOC = "templates/aggregated/adoc/header.adoc";
            static final String MARKDOWN = "templates/aggregated/md/header.md";
            static final String HTML = "templates/aggregated/html/header.html";
            static final String XML = "templates/aggregated/xml/header.xml";

            HeaderTemplateConstants() {
            }
        }

        static class SingleTemplateConstants {
            static final String ADOC = "templates/single/single-document-template.adoc";
            static final String MARKDOWN = "templates/single/single-document-template.md";
            static final String HTML = "templates/single/single-document-template.html";
            static final String XML = "templates/single/single-document-template.xml";

            SingleTemplateConstants() {
            }
        }
    }

    static class CompactTemplates {
        CompactTemplates() {
        }

        static class FooterTemplateConstants {
            static final String ADOC = "templates/aggregated/adoc/compact-footer.adoc";
            static final String MARKDOWN = "templates/aggregated/md/compact-footer.md";
            static final String HTML = "templates/aggregated/html/compact-footer.html";

            FooterTemplateConstants() {
            }
        }

        static class ContentTemplateConstants {
            static final String ADOC = "templates/partials/adoc/compact-content.adoc";
            static final String MARKDOWN = "templates/partials/md/compact-content.md";
            static final String HTML = "templates/partials/html/compact-content.html";

            ContentTemplateConstants() {
            }
        }

        static class HeaderTemplateConstants {
            static final String ADOC = "templates/aggregated/adoc/compact-header.adoc";
            static final String MARKDOWN = "templates/aggregated/md/compact-header.md";
            static final String HTML = "templates/aggregated/html/compact-header.html";

            HeaderTemplateConstants() {
            }
        }

        static class SingleTemplateConstants {
            static final String ADOC = "templates/single/compact-single-document-template.adoc";
            static final String MARKDOWN = "templates/single/compact-single-document-template.md";
            static final String HTML = "templates/single/compact-single-document-template.html";

            SingleTemplateConstants() {
            }
        }
    }
}

