/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rodnansol.core.generator.reader.MetadataConversionException;
import org.rodnansol.core.generator.template.data.Property;
import org.rodnansol.core.generator.template.data.PropertyDeprecation;
import org.rodnansol.core.generator.template.data.PropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;
import org.springframework.boot.configurationprocessor.metadata.JsonMarshaller;

public class MetadataReader {
    public static final MetadataReader INSTANCE = new MetadataReader();
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataReader.class);

    private MetadataReader() {
    }

    public Map<String, List<Property>> readPropertiesAsMap(InputStream metadataStream) {
        Objects.requireNonNull(metadataStream, "metadataStream is NULL");
        try {
            ConfigurationMetadata configurationMetadata = new JsonMarshaller().read(metadataStream);
            Map<String, List<Property>> propertyMap = this.getPropertyMap(configurationMetadata);
            LOGGER.trace("Configuration metadata contains number of properties:[{}]", (Object)propertyMap.size());
            return propertyMap;
        }
        catch (Exception e) {
            throw new MetadataConversionException("Error during converting properties to Map", e);
        }
    }

    public List<PropertyGroup> readPropertiesAsPropertyGroupList(InputStream metadataStream) {
        Objects.requireNonNull(metadataStream, "metadataStream is NULL");
        try {
            ConfigurationMetadata configurationMetadata = new JsonMarshaller().read(metadataStream);
            Map<String, List<Property>> propertyMap = this.getPropertyMap(configurationMetadata);
            Map<String, List<PropertyGroup>> propertyGroupsByType = this.getPropertyGroups(configurationMetadata);
            this.updateGroupsWithPropertiesAndAssociations(propertyMap, propertyGroupsByType);
            LOGGER.trace("Configuration metadata contains number of group:[{}] and properties:[{}]", (Object)propertyGroupsByType.size(), (Object)propertyMap.size());
            return this.flattenValues(propertyGroupsByType);
        }
        catch (Exception e) {
            throw new MetadataConversionException("Error during converting properties to list of ProperyGroups", e);
        }
    }

    private PropertyGroup setProperties(Map<String, List<Property>> propertyMap, PropertyGroup propertyGroup) {
        List<Property> properties = propertyMap.get(propertyGroup.getType());
        if (properties == null || properties.isEmpty()) {
            LOGGER.warn("Property group with name:[{}] is having no properties, please check if you provided the getter/setter methods. If your class is empty intentionally, please forget this warning here.", (Object)propertyGroup.getGroupName());
            return propertyGroup;
        }
        List<Property> collectedProperties = properties.stream().map(property -> this.updateProperty(propertyGroup, (Property)property)).collect(Collectors.toList());
        propertyGroup.setProperties(collectedProperties);
        return propertyGroup;
    }

    private Property updateProperty(PropertyGroup propertyGroup, Property property) {
        String groupName = propertyGroup.getGroupName();
        if (propertyGroup.isUnknownGroup()) {
            property.setKey(property.getFqName());
        } else {
            property.setKey(property.getFqName().substring(groupName.length() + 1));
        }
        return property;
    }

    private List<PropertyGroup> flattenValues(Map<String, List<PropertyGroup>> propertyGroupsByType) {
        return propertyGroupsByType.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void updateGroupsWithPropertiesAndAssociations(Map<String, List<Property>> propertyMap, Map<String, List<PropertyGroup>> propertyGroupsByType) {
        for (Map.Entry<String, List<PropertyGroup>> entry : propertyGroupsByType.entrySet()) {
            List<PropertyGroup> nestedProperties = this.updatePropertiesAndReturnNestedGroups(propertyMap, entry);
            for (PropertyGroup nestedProperty : nestedProperties) {
                List<PropertyGroup> parentList = propertyGroupsByType.get(nestedProperty.getSourceType());
                parentList.stream().filter(propertyGroup -> propertyGroup.getType().equals(nestedProperty.getSourceType())).findFirst().ifPresent(parent -> {
                    parent.addChildGroup(nestedProperty);
                    nestedProperty.setParentGroup((PropertyGroup)parent);
                });
            }
        }
    }

    private List<PropertyGroup> updatePropertiesAndReturnNestedGroups(Map<String, List<Property>> propertyMap, Map.Entry<String, List<PropertyGroup>> propertyEntry) {
        return propertyEntry.getValue().stream().map(propertyGroup -> this.setProperties(propertyMap, (PropertyGroup)propertyGroup)).filter(PropertyGroup::isNested).collect(Collectors.toList());
    }

    private Map<String, List<PropertyGroup>> getPropertyGroups(ConfigurationMetadata configurationMetadata) {
        Map<String, List<PropertyGroup>> propertyGroupMap = configurationMetadata.getItems().stream().filter(itemMetadata -> itemMetadata.isOfItemType(ItemMetadata.ItemType.GROUP)).map(itemMetadata -> new PropertyGroup(itemMetadata.getName(), itemMetadata.getType(), this.getSourceTypeOrDefault((ItemMetadata)itemMetadata))).collect(Collectors.groupingBy(PropertyGroup::getSourceType, Collectors.toList()));
        ArrayList<PropertyGroup> value = new ArrayList<PropertyGroup>();
        value.add(PropertyGroup.createUnknownGroup());
        propertyGroupMap.put("Unknown", value);
        return propertyGroupMap;
    }

    private Map<String, List<Property>> getPropertyMap(ConfigurationMetadata configurationMetadata) {
        Function<ItemMetadata, String> getSourceType = this::getSourceTypeOrDefault;
        return configurationMetadata.getItems().stream().filter(itemMetadata -> itemMetadata.isOfItemType(ItemMetadata.ItemType.PROPERTY)).collect(Collectors.groupingBy(getSourceType, Collectors.mapping(this::mapToProperty, Collectors.toList())));
    }

    private String getSourceTypeOrDefault(ItemMetadata current) {
        return Optional.ofNullable(current.getSourceType()).orElse("Unknown");
    }

    private Property mapToProperty(ItemMetadata itemMetadata) {
        ItemDeprecation deprecation;
        Property property = new Property(itemMetadata.getName(), itemMetadata.getType());
        property.setDescription(itemMetadata.getDescription());
        if (itemMetadata.getDefaultValue() != null) {
            property.setDefaultValue(itemMetadata.getDefaultValue().toString());
        }
        if ((deprecation = itemMetadata.getDeprecation()) != null) {
            PropertyDeprecation propertyDeprecation = new PropertyDeprecation(deprecation.getReason(), deprecation.getReplacement());
            property.setPropertyDeprecation(propertyDeprecation);
        }
        return property;
    }
}

