/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationAction.class);
    private final Project project;
    private final List<File> inputFiles;
    private final File outputFile;

    public AggregationAction(Project project, List<File> inputFiles, File outputFile) {
        this.project = project;
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
    }

    public void executeAggregation() {
        if (this.emptyInputFiles()) {
            this.aggregateAlreadyExistingSources();
        } else {
            this.aggregateSpecifiedInputFiles();
        }
    }

    private boolean emptyInputFiles() {
        return this.inputFiles == null || this.inputFiles.isEmpty();
    }

    private void aggregateAlreadyExistingSources() throws DocumentGenerationException {
        if (this.outputFile == null) {
            LOGGER.debug("Input files are empty and output file is not specified, creating aggregations from all existing sources...");
            this.createAggregatedFilesFromExistingSources();
        } else {
            String requestedExtension = this.getFileExtension(this.outputFile);
            LOGGER.debug("Input files are empty but output file is specified with the following extension:[{}], files with that extension will be aggregated", (Object)requestedExtension);
            this.createAggregatedFilesFromExistingSourcesWithGivenExtension(this.outputFile.getAbsolutePath(), requestedExtension);
        }
    }

    private void aggregateSpecifiedInputFiles() throws DocumentGenerationException {
        String requiredExtension = this.getFileExtension(this.inputFiles.get(0));
        boolean allMatch = this.inputFiles.stream().allMatch(file -> this.getFileExtension((File)file).equals(requiredExtension));
        if (!allMatch) {
            throw new DocumentGenerationException("Unable to aggregate files with different extensions");
        }
        if (this.outputFile == null) {
            String aggregatedTargetFileName = this.project.getDefaultAggregatedTargetFilePath(requiredExtension);
            LOGGER.debug("Input files are specified, but the output file is missing, aggregating files with the following extension:[{}] into [{}]", (Object)requiredExtension, (Object)aggregatedTargetFileName);
            this.aggregateFiles(aggregatedTargetFileName, this.inputFiles);
        } else {
            LOGGER.debug("Input files are specified and the output file is also specified, creating aggregation to the following file:[{}]", (Object)this.outputFile);
            this.aggregateFiles(this.outputFile.getAbsolutePath(), this.inputFiles);
        }
    }

    private void createAggregatedFilesFromExistingSources() throws DocumentGenerationException {
        Map<String, List<File>> fileExtensionMap = this.getChildModuleBasedDocumentationsGroupedByFileExtensions();
        if (fileExtensionMap.isEmpty()) {
            LOGGER.info("No files to be aggregated...");
            return;
        }
        for (Map.Entry<String, List<File>> entry : fileExtensionMap.entrySet()) {
            String aggregatedTargetFileName = this.project.getDefaultAggregatedTargetFilePath(entry.getKey());
            List<File> files = entry.getValue();
            this.aggregateFiles(aggregatedTargetFileName, files);
        }
    }

    private void createAggregatedFilesFromExistingSourcesWithGivenExtension(String outputFileName, String extension) throws DocumentGenerationException {
        Map<String, List<File>> fileExtensionMap = this.getChildModuleBasedDocumentationsGroupedByFileExtensions();
        if (fileExtensionMap.isEmpty()) {
            LOGGER.info("No files to be aggregated...");
            return;
        }
        List<File> requestedFiles = fileExtensionMap.get(extension);
        if (requestedFiles != null) {
            this.aggregateFiles(outputFileName, requestedFiles);
        }
    }

    private void aggregateFiles(String aggregatedTargetFileName, List<File> files) throws DocumentGenerationException {
        try (FileWriter fileWriter = new FileWriter(CoreFileUtils.initializeFileWithPath(aggregatedTargetFileName));){
            LOGGER.info("Aggregating files:[{}] into: [{}]", files, (Object)aggregatedTargetFileName);
            for (File file : files) {
                String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                fileWriter.append(content);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to generate aggregated file at path:[" + aggregatedTargetFileName + "], please check the logs for more information", (Throwable)e);
        }
    }

    private Map<String, List<File>> getChildModuleBasedDocumentationsGroupedByFileExtensions() {
        return this.project.getModules().stream().map(this.project::getDefaultOutputFolder).map(this::listFilesOfGivenFolder).filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.groupingBy(this::getFileExtension));
    }

    private String getFileExtension(File item) {
        return FilenameUtils.getExtension((String)item.getName());
    }

    private File[] listFilesOfGivenFolder(String outputFolder) {
        return Path.of(outputFolder, new String[0]).toFile().listFiles();
    }
}

