/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoreFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreFileUtils.class);

    private CoreFileUtils() {
    }

    public static File initializeFileWithPath(String targetFilePath) throws DocumentGenerationException {
        File outputFile = new File(targetFilePath);
        if (!outputFile.exists()) {
            try {
                CoreFileUtils.createParentDirectoriesIfNeeded(targetFilePath, outputFile);
                CoreFileUtils.createTheTargetFile(targetFilePath, outputFile);
            }
            catch (IOException e) {
                throw new DocumentGenerationException("Unable to create output file:[" + outputFile + "]", e);
            }
        }
        return outputFile;
    }

    public static File initializeFileWithPath(File targetFile) throws DocumentGenerationException {
        return CoreFileUtils.initializeFileWithPath(targetFile.getPath());
    }

    public static boolean isJarOrZipFile(File input) {
        String extension = FilenameUtils.getExtension((String)input.getName());
        return extension.equals("jar") || extension.equals("zip");
    }

    private static void createTheTargetFile(String targetFilePath, File outputFile) throws IOException {
        boolean newFile = outputFile.createNewFile();
        if (newFile) {
            LOGGER.debug("File at path:[{}] were created", (Object)targetFilePath);
        } else {
            LOGGER.debug("File at path:[{}] already exists, new file were not created...", (Object)targetFilePath);
        }
    }

    private static void createParentDirectoriesIfNeeded(String targetFilePath, File outputFile) {
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            boolean created = parentFile.mkdirs();
            if (created) {
                LOGGER.debug("Parent folders for path:[{}] were created", (Object)targetFilePath);
            } else {
                LOGGER.debug("Parent folders for path:[{}] were NOT created", (Object)targetFilePath);
            }
        }
    }
}

