/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.project.gradle;

import java.io.File;
import java.util.List;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.project.ProjectType;

public class GradleProject
extends Project {
    private static final String DEFAULT_TARGET_FOLDER = "property-docs";
    private static final String DEFAULT_OUTPUT_DIRECTORY = "%s/build/property-docs";
    private static final String DEFAULT_TARGET_FILE_PATH = "%s/%s-property-docs%s";
    private static final String DEFAULT_AGGREGATED_FILE_PATH = "%s/%s-property-docs-aggregated.%s";

    public GradleProject(File basedir, String name) {
        super(basedir, name, ProjectType.GRADLE);
    }

    public GradleProject(File basedir, String name, List<String> modules) {
        super(basedir, name, ProjectType.GRADLE);
        this.modules = modules;
    }

    @Override
    public String getDefaultOutputFolder(String moduleName) {
        return this.getBasedir() + "/" + String.format(DEFAULT_OUTPUT_DIRECTORY, moduleName);
    }

    @Override
    public String getDefaultOutputFolder() {
        return String.format(DEFAULT_OUTPUT_DIRECTORY, this.getBasedir());
    }

    @Override
    public String getDefaultTargetFilePath(TemplateType templateType) {
        return String.format(DEFAULT_TARGET_FILE_PATH, this.getDefaultOutputFolder(), this.getName(), templateType.getExtension());
    }

    @Override
    public String getDefaultAggregatedTargetFilePath(String extension) {
        return String.format(DEFAULT_AGGREGATED_FILE_PATH, this.getDefaultOutputFolder(), this.getName(), extension);
    }

    @Override
    public List<String> getPossibleMetadataFilePaths() {
        return List.of("/build/classes/java/main/META-INF/spring-configuration-metadata.json", "/classes/java/main/META-INF/spring-configuration-metadata.json", "/java/main/META-INF/spring-configuration-metadata.json", "/main/META-INF/spring-configuration-metadata.json", "/META-INF/spring-configuration-metadata.json", "/spring-configuration-metadata.json");
    }
}

