/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer.postprocess;

import java.util.List;
import java.util.Objects;
import org.rodnansol.core.generator.template.PropertyGroup;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;

public class PostProcessPropertyGroupsCommand {
    private final TemplateCustomization templateCustomization;
    private final List<PropertyGroup> propertyGroups;
    private final List<String> excludedGroups;
    private final List<String> includedGroups;
    private final List<String> excludedProperties;
    private final List<String> includedProperties;

    public PostProcessPropertyGroupsCommand(TemplateCustomization templateCustomization, List<PropertyGroup> propertyGroups, List<String> excludedGroups, List<String> includedGroups, List<String> excludedProperties, List<String> includedProperties) {
        this.templateCustomization = templateCustomization;
        this.propertyGroups = propertyGroups;
        this.excludedGroups = excludedGroups;
        this.includedGroups = includedGroups;
        this.excludedProperties = excludedProperties;
        this.includedProperties = includedProperties;
    }

    public static PostProcessPropertyGroupsCommand ofTemplate(TemplateCustomization templateCustomization, List<PropertyGroup> propertyGroups) {
        return new PostProcessPropertyGroupsCommand(templateCustomization, propertyGroups, null, null, null, null);
    }

    public static PostProcessPropertyGroupsCommand ofPropertyFilter(List<PropertyGroup> propertyGroups, List<String> excludedProperties, List<String> includedProperties) {
        return new PostProcessPropertyGroupsCommand(null, propertyGroups, null, null, excludedProperties, includedProperties);
    }

    public static PostProcessPropertyGroupsCommand ofGroupFilter(List<PropertyGroup> propertyGroups, List<String> excludedGroups, List<String> includedGroups) {
        return new PostProcessPropertyGroupsCommand(null, propertyGroups, excludedGroups, includedGroups, null, null);
    }

    public TemplateCustomization getTemplateCustomization() {
        return this.templateCustomization;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public List<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public List<String> getExcludedProperties() {
        return this.excludedProperties;
    }

    public List<String> getIncludedProperties() {
        return this.includedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostProcessPropertyGroupsCommand that = (PostProcessPropertyGroupsCommand)o;
        return Objects.equals(this.templateCustomization, that.templateCustomization) && Objects.equals(this.excludedGroups, that.excludedGroups) && Objects.equals(this.includedGroups, that.includedGroups) && Objects.equals(this.excludedProperties, that.excludedProperties) && Objects.equals(this.includedProperties, that.includedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.templateCustomization, this.excludedGroups, this.includedGroups, this.excludedProperties, this.includedProperties);
    }

    public String toString() {
        return "PostProcessPropertyGroupsCommand{templateCustomization=" + this.templateCustomization + ", propertyGroups=" + this.propertyGroups + ", excludedGroups=" + this.excludedGroups + ", includedGroups=" + this.includedGroups + ", excludedProperties=" + this.excludedProperties + ", includedProperties=" + this.includedProperties + "}";
    }
}

