/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer.postprocess;

import java.util.List;
import org.rodnansol.core.generator.template.PropertyGroup;
import org.rodnansol.core.generator.writer.postprocess.PostProcessPropertyGroupsCommand;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IncludeExcludeGroupPostProcessor
implements PropertyGroupPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeExcludeGroupPostProcessor.class);

    IncludeExcludeGroupPostProcessor() {
    }

    @Override
    public void postProcess(PostProcessPropertyGroupsCommand command) {
        List<PropertyGroup> propertyGroups = command.getPropertyGroups();
        List<String> includeList = command.getIncludedGroups();
        List<String> excludeList = command.getExcludedGroups();
        LOGGER.debug("Filtering incoming property group list with include list:[{}] and exclude list:[{}]", includeList, excludeList);
        if (includeList != null && !includeList.isEmpty() && propertyGroups != null) {
            propertyGroups.removeIf(group -> !includeList.contains(group.getGroupName()));
            return;
        }
        if (excludeList != null && !excludeList.isEmpty() && propertyGroups != null) {
            propertyGroups.removeIf(group -> excludeList.contains(group.getGroupName()));
        }
    }
}

