/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.rodnansol.core.generator.template.Property;

public class PropertyGroup {
    private String groupName;
    private final String type;
    private final String sourceType;
    private List<Property> properties;
    private PropertyGroup parentGroup;
    private List<PropertyGroup> childrenGroups;
    private boolean nested;
    private boolean unknownGroup = false;

    public PropertyGroup(String groupName, String type, String sourceType) {
        this.groupName = groupName;
        this.type = type;
        this.sourceType = sourceType;
        this.nested = !type.equals(sourceType);
    }

    public PropertyGroup(String groupName, String type, String sourceType, List<Property> properties) {
        this.groupName = groupName;
        this.type = type;
        this.sourceType = sourceType;
        this.nested = !type.equals(sourceType);
        this.properties = properties;
    }

    public static PropertyGroup createUnknownGroup() {
        PropertyGroup propertyGroup = new PropertyGroup("Unknown group", "Unknown", "Unknown");
        propertyGroup.setUnknownGroup(true);
        return propertyGroup;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getType() {
        return this.type;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public PropertyGroup getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(PropertyGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public List<PropertyGroup> getChildrenGroups() {
        return this.childrenGroups;
    }

    public boolean isUnknownGroup() {
        return this.unknownGroup;
    }

    public void setUnknownGroup(boolean unknownGroup) {
        this.unknownGroup = unknownGroup;
    }

    public PropertyGroup addChildGroup(PropertyGroup childGroup) {
        if (this.childrenGroups == null) {
            this.childrenGroups = new ArrayList<PropertyGroup>();
        }
        this.childrenGroups.add(childGroup);
        return this;
    }

    public PropertyGroup addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
        return this;
    }

    public String toString() {
        return "PropertyGroup{groupName='" + this.groupName + "', type='" + this.type + "', sourceType='" + this.sourceType + "', properties=" + this.properties + ", parentGroup=" + this.parentGroup + ", nested=" + this.nested + ", unknownGroup=" + this.unknownGroup + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyGroup that = (PropertyGroup)o;
        return this.nested == that.nested && this.unknownGroup == that.unknownGroup && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.type, that.type) && Objects.equals(this.sourceType, that.sourceType) && Objects.equals(this.properties, that.properties) && Objects.equals(this.parentGroup, that.parentGroup);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.type, this.sourceType, this.properties, this.parentGroup, this.nested, this.unknownGroup);
    }
}

