/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.template.TemplateCompiler;
import org.rodnansol.core.generator.template.TemplateData;
import org.rodnansol.core.generator.template.handlebars.EnvironmentVariableHelper;
import org.rodnansol.core.generator.template.handlebars.IncludeEnvironmentVariableFormatHelper;
import org.rodnansol.core.generator.template.handlebars.WorkingDirectoryAwareRecursiveFileTemplateLoader;
import org.rodnansol.core.generator.template.handlebars.WorkingDirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsTemplateCompiler
implements TemplateCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlebarsTemplateCompiler.class);
    private final Handlebars handlebars;

    public HandlebarsTemplateCompiler(Handlebars handlebars) {
        this.handlebars = handlebars;
    }

    public HandlebarsTemplateCompiler() {
        this(HandlebarsTemplateCompiler.createDefaultHandlebarsInstance());
    }

    private static Handlebars createDefaultHandlebarsInstance() {
        return new Handlebars().registerHelper("as_env", (Helper)new EnvironmentVariableHelper()).registerHelper("include_env_format", (Helper)new IncludeEnvironmentVariableFormatHelper()).with(new TemplateLoader[]{new ClassPathTemplateLoader(), new WorkingDirectoryAwareRecursiveFileTemplateLoader(".", WorkingDirectoryProvider.INSTANCE)});
    }

    @Override
    public String compileTemplate(String templatePath, TemplateData templateData) throws DocumentGenerationException {
        LOGGER.debug("Compiling template:[{}] with data:[{}]", (Object)templatePath, (Object)templatePath);
        Objects.requireNonNull(templatePath, "templatePath is NULL");
        Objects.requireNonNull(templateData, "templateData is NULL");
        try {
            this.setLocalizationIfPossible(templateData);
            return this.handlebars.compile(templatePath).apply((Object)templateData);
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Error during compiling the template with Handlebars engine", e);
        }
    }

    private void setLocalizationIfPossible(TemplateData templateData) {
        try {
            Helper i18n;
            if (templateData.getTemplateCustomization() != null && templateData.getTemplateCustomization().getLocale() != null && (i18n = this.handlebars.helper("i18n")) instanceof I18nHelper) {
                String locale = templateData.getTemplateCustomization().getLocale();
                LOGGER.debug("Setting locale to: [{}]", (Object)locale);
                ((I18nHelper)i18n).setDefaultLocale(Locale.forLanguageTag(locale));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during setting the Localization for the documents, please check the logs for more information.");
        }
    }
}

