/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template.handlebars;

import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.rodnansol.core.generator.template.handlebars.WorkingDirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingDirectoryAwareRecursiveFileTemplateLoader
extends FileTemplateLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkingDirectoryAwareRecursiveFileTemplateLoader.class);
    private final WorkingDirectoryProvider workingDirectoryProvider;

    public WorkingDirectoryAwareRecursiveFileTemplateLoader(String basedir, String suffix, WorkingDirectoryProvider workingDirectoryProvider) {
        super(basedir, suffix);
        this.workingDirectoryProvider = workingDirectoryProvider;
    }

    public WorkingDirectoryAwareRecursiveFileTemplateLoader(String basedir, WorkingDirectoryProvider workingDirectoryProvider) {
        super(basedir);
        this.workingDirectoryProvider = workingDirectoryProvider;
    }

    protected URL getResource(String location) throws IOException {
        LOGGER.debug("Resolving template with the following location:[{}]", (Object)location);
        URL resource = super.getResource(location);
        if (resource != null) {
            return resource;
        }
        String normalizedInput = Path.of(location, new String[0]).normalize().toString();
        String extension = FilenameUtils.getExtension((String)location);
        Collection childFiles = FileUtils.listFiles((File)this.workingDirectoryProvider.getCurrentWorkingDirectoryPath().toFile(), (String[])new String[]{extension}, (boolean)true);
        File optionalFile = childFiles.stream().filter(file -> file.getPath().contains(normalizedInput)).findFirst().orElse(null);
        if (optionalFile == null) {
            return null;
        }
        LOGGER.debug("Final location:[{}] for input:[{}]", (Object)optionalFile.getPath(), (Object)location);
        return optionalFile.exists() ? optionalFile.toURI().toURL() : null;
    }
}

