/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.action;

import java.io.File;
import java.io.IOException;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.HandlebarsTemplateCompiler;
import org.rodnansol.core.generator.template.TemplateCompilerFactory;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.writer.CreateDocumentCommand;
import org.rodnansol.core.generator.writer.Documenter;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGenerationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentGenerationAction.class);
    private final Project project;
    private final String name;
    private final String description;
    private final TemplateType templateType;
    private final File metadataInput;
    private final TemplateCustomization templateCustomization;
    private String template;
    private File outputFile;
    private String templateCompilerName = HandlebarsTemplateCompiler.class.getName();

    public DocumentGenerationAction(Project project, String name, String description, TemplateCustomization templateCustomization, String template, TemplateType templateType, File metadataInput, File outputFile) {
        this.project = project;
        this.name = name;
        this.description = description;
        this.templateCustomization = templateCustomization;
        this.template = template;
        this.templateType = templateType;
        this.metadataInput = metadataInput;
        this.outputFile = outputFile;
    }

    public void execute() {
        this.initializeTemplate(this.templateType);
        this.checkOutputFileAndCreateIfDoesNotExist(this.templateType);
        LOGGER.info("Creating property document file at:[{}]", (Object)this.outputFile);
        this.generateDocument();
    }

    private void generateDocument() throws DocumentGenerationException {
        try {
            Documenter documenter = new Documenter(MetadataReader.INSTANCE, TemplateCompilerFactory.getInstance(this.templateCompilerName), MetadataInputResolverContext.INSTANCE);
            CreateDocumentCommand command = new CreateDocumentCommand(this.project, this.name, this.metadataInput, this.template, this.outputFile, this.templateCustomization);
            command.setDescription(this.description);
            documenter.readMetadataAndGenerateRenderedFile(command);
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Unable to create final document", e);
        }
    }

    private void initializeTemplate(TemplateType templateType) {
        if (this.template == null) {
            this.template = templateType.getSingleTemplate();
        }
    }

    private void checkOutputFileAndCreateIfDoesNotExist(TemplateType templateType) throws DocumentGenerationException {
        if (this.outputFile != null) {
            String extension = templateType.getExtension();
            if (!this.outputFile.getName().endsWith(extension)) {
                throw new DocumentGenerationException("Output file does not have the proper extension, requested file name:[" + this.outputFile + "] with requested extension:[" + extension + "]");
            }
        } else {
            this.outputFile = CoreFileUtils.initializeFileWithPath(this.project.getDefaultTargetFilePath(templateType));
        }
    }

    public void setTemplateCompilerName(String templateCompilerName) {
        this.templateCompilerName = templateCompilerName;
    }
}

