/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.project;

import java.io.File;
import java.util.List;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.project.ProjectType;
import org.rodnansol.core.project.gradle.GradleProject;
import org.rodnansol.core.project.maven.MavenProject;
import org.rodnansol.core.project.simple.SimpleProject;

public class ProjectFactory {
    private ProjectFactory() {
    }

    public static MavenProject ofMavenProject(File basedir, String name) {
        return new MavenProject(basedir, name);
    }

    public static MavenProject ofMavenProject(File basedir, String name, List<String> modules) {
        return new MavenProject(basedir, name, modules);
    }

    public static GradleProject ofGradleProject(File basedir, String name) {
        return new GradleProject(basedir, name);
    }

    public static GradleProject ofGradleProject(File basedir, String name, List<String> modules) {
        return new GradleProject(basedir, name, modules);
    }

    public static SimpleProject ofSimpleProject(File basedir, String name) {
        return new SimpleProject(basedir, name);
    }

    public static Project ofType(File basedir, String name, ProjectType projectType) {
        Project project = null;
        switch (projectType) {
            case MAVEN: {
                project = ProjectFactory.ofMavenProject(basedir, name);
                break;
            }
            case GRADLE: {
                project = ProjectFactory.ofGradleProject(basedir, name);
                break;
            }
            case SIMPLE: {
                project = ProjectFactory.ofSimpleProject(basedir, name);
            }
        }
        return project;
    }

    public static Project ofTypeWithModules(File basedir, String name, List<String> modules, ProjectType projectType) {
        Project project = null;
        switch (projectType) {
            case MAVEN: {
                project = ProjectFactory.ofMavenProject(basedir, name, modules);
                break;
            }
            case GRADLE: {
                project = ProjectFactory.ofGradleProject(basedir, name, modules);
                break;
            }
            case SIMPLE: {
                project = ProjectFactory.ofSimpleProject(basedir, name);
            }
        }
        return project;
    }
}

