/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.MainTemplateData;
import org.rodnansol.core.generator.template.PropertyGroup;
import org.rodnansol.core.generator.template.TemplateCompiler;
import org.rodnansol.core.generator.writer.CreateDocumentCommand;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Documenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Documenter.class);
    private final MetadataReader metadataReader;
    private final TemplateCompiler templateCompiler;
    private final MetadataInputResolverContext metadataInputResolverContext;

    public Documenter(MetadataReader metadataReader, TemplateCompiler templateCompiler, MetadataInputResolverContext metadataInputResolverContext) {
        this.metadataReader = metadataReader;
        this.templateCompiler = templateCompiler;
        this.metadataInputResolverContext = metadataInputResolverContext;
    }

    public void readMetadataAndGenerateRenderedFile(CreateDocumentCommand createDocumentCommand) throws IOException {
        LOGGER.debug("Creating document with command:[{}]", (Object)createDocumentCommand);
        MainTemplateData mainTemplateData = this.createTemplateData(createDocumentCommand);
        String content = this.templateCompiler.compileTemplate(createDocumentCommand.getTemplate(), mainTemplateData);
        try (FileWriter fileWriter = new FileWriter(CoreFileUtils.initializeFileWithPath(createDocumentCommand.getOutput()));){
            LOGGER.debug("Writing generated content to file:[{}]", (Object)createDocumentCommand.getOutput());
            fileWriter.write(content);
        }
    }

    private MainTemplateData createTemplateData(CreateDocumentCommand createDocumentCommand) throws IOException {
        try (InputStream inputStream = this.metadataInputResolverContext.getInputStreamFromFile(createDocumentCommand.getProject(), createDocumentCommand.getMetadataInput());){
            List<PropertyGroup> propertyGroups = this.metadataReader.readPropertiesAsPropertyGroupList(inputStream);
            MainTemplateData mainTemplateData = MainTemplateData.ofMainSection(createDocumentCommand.getName(), propertyGroups);
            mainTemplateData.setGenerationDate(LocalDateTime.now());
            mainTemplateData.setMainDescription(createDocumentCommand.getDescription());
            mainTemplateData.setTemplateCustomization(createDocumentCommand.getTemplateCustomization());
            MainTemplateData mainTemplateData2 = mainTemplateData;
            return mainTemplateData2;
        }
    }
}

