/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.writer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.MainTemplateData;
import org.rodnansol.core.generator.template.PropertyGroup;
import org.rodnansol.core.generator.template.SubTemplateData;
import org.rodnansol.core.generator.template.TemplateCompiler;
import org.rodnansol.core.generator.template.TemplateData;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.writer.CombinedInput;
import org.rodnansol.core.generator.writer.CreateAggregationCommand;
import org.rodnansol.core.util.CoreFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationDocumenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationDocumenter.class);
    private final MetadataReader metadataReader;
    private final TemplateCompiler templateCompiler;
    private final MetadataInputResolverContext metadataInputResolverContext;

    public AggregationDocumenter(MetadataReader metadataReader, TemplateCompiler templateCompiler, MetadataInputResolverContext metadataInputResolverContext) {
        this.metadataReader = metadataReader;
        this.templateCompiler = templateCompiler;
        this.metadataInputResolverContext = metadataInputResolverContext;
    }

    public void createDocumentsAndAggregate(CreateAggregationCommand createAggregationCommand) {
        Objects.requireNonNull(createAggregationCommand, "createAggregationCommand is NULL");
        LOGGER.info("Creating documents and aggregating them based on the incoming command:[{}]", (Object)createAggregationCommand);
        ArrayList<SubTemplateData> subTemplateDataList = new ArrayList<SubTemplateData>(createAggregationCommand.getCombinedInputs().size());
        ArrayList<PropertyGroup> propertyGroups = new ArrayList<PropertyGroup>(createAggregationCommand.getCombinedInputs().size());
        for (CombinedInput entry : createAggregationCommand.getCombinedInputs()) {
            LOGGER.info("Processing entry:[{}]", (Object)entry);
            try {
                InputStream inputStream = this.metadataInputResolverContext.getInputStreamFromFile(createAggregationCommand.getProject(), entry.getInput());
                try {
                    List<PropertyGroup> groups = this.metadataReader.readPropertiesAsPropertyGroupList(inputStream);
                    propertyGroups.addAll(groups);
                    subTemplateDataList.add(this.createModuleTemplateData(entry.getSectionName(), groups, entry.getDescription()));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error during reading an entry:[" + entry.getInput() + "]", (Throwable)e);
            }
        }
        this.createAndWriteContent(createAggregationCommand, subTemplateDataList, propertyGroups);
    }

    private void createAndWriteContent(CreateAggregationCommand createAggregationCommand, List<SubTemplateData> subTemplateDataList, List<PropertyGroup> propertyGroups) {
        TemplateType templateType = createAggregationCommand.getTemplateType();
        MainTemplateData mainTemplateData = this.createMainTemplateData(createAggregationCommand, propertyGroups);
        mainTemplateData.setSubTemplateDataList(subTemplateDataList);
        String header = this.templateCompiler.compileTemplate(templateType.getHeaderTemplate(), mainTemplateData);
        String footer = this.templateCompiler.compileTemplate(templateType.getFooterTemplate(), mainTemplateData);
        String aggregatedContent = subTemplateDataList.stream().map(templateData -> this.templateCompiler.compileTemplate(templateType.getContentTemplate(), (TemplateData)templateData)).reduce("", String::concat);
        try (FileWriter fileWriter = new FileWriter(CoreFileUtils.initializeFileWithPath(createAggregationCommand.getOutput()));){
            LOGGER.debug("Writing aggregated content to file:[{}]", (Object)createAggregationCommand.getOutput());
            fileWriter.append(header).append(aggregatedContent).append(footer);
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Error during writing content to file...", e);
        }
    }

    private SubTemplateData createModuleTemplateData(String sectionName, List<PropertyGroup> propertyGroups, String description) {
        SubTemplateData subTemplateData = new SubTemplateData(sectionName, propertyGroups);
        subTemplateData.setGenerationDate(LocalDateTime.now());
        subTemplateData.setModuleDescription(description);
        return subTemplateData;
    }

    private MainTemplateData createMainTemplateData(CreateAggregationCommand createAggregationCommand, List<PropertyGroup> propertyGroups) {
        MainTemplateData mainTemplateData = new MainTemplateData(createAggregationCommand.getAggregatedDocumentHeader(), propertyGroups);
        mainTemplateData.setMainDescription(createAggregationCommand.getDescription());
        mainTemplateData.setGenerationDate(LocalDateTime.now());
        mainTemplateData.setTemplateCustomization(createAggregationCommand.getTemplateCustomization());
        return mainTemplateData;
    }
}

