/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.template;

import com.github.jknack.handlebars.Handlebars;
import java.io.IOException;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.template.TemplateCompiler;
import org.rodnansol.core.generator.template.TemplateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsTemplateCompiler
implements TemplateCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlebarsTemplateCompiler.class);

    @Override
    public String compileTemplate(String templatePath, TemplateData templateData) throws DocumentGenerationException {
        LOGGER.debug("Compiling template:[{}] with data:[{}]", (Object)templatePath, (Object)templatePath);
        try {
            return new Handlebars().compile(templatePath).apply((Object)templateData);
        }
        catch (IOException e) {
            throw new DocumentGenerationException("Error during compiling the template with Handlebars engine", e);
        }
    }
}

