/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.core.generator.resolver;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.rodnansol.core.generator.DocumentGenerationException;
import org.rodnansol.core.generator.resolver.DirectoryMetadataInputResolver;
import org.rodnansol.core.generator.resolver.FileMetadataInputResolver;
import org.rodnansol.core.generator.resolver.JarFileMetadataInputResolver;
import org.rodnansol.core.generator.resolver.MetadataInputResolver;
import org.rodnansol.core.project.Project;

public class MetadataInputResolverContext {
    public static final MetadataInputResolverContext INSTANCE = new MetadataInputResolverContext();
    private static final List<MetadataInputResolver> METADATA_INPUT_RESOLVERS = List.of(new JarFileMetadataInputResolver(), new FileMetadataInputResolver(), new DirectoryMetadataInputResolver());

    public InputStream getInputStreamFromFile(Project project, File input) {
        for (MetadataInputResolver metadataInputResolver : METADATA_INPUT_RESOLVERS) {
            InputStream inputStream;
            if (!metadataInputResolver.supports(input) || (inputStream = metadataInputResolver.resolveInputStream(project, input)) == null) continue;
            return inputStream;
        }
        throw new DocumentGenerationException("Unable to locate the spring-configuration-metadata.json file from the given input:[" + input + "]");
    }
}

