/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.generator.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.rodnansol.generator.UnknownContentTypeException;
import org.rodnansol.generator.io.ContentResolver;
import org.rodnansol.generator.io.JsonContentResolver;
import org.rodnansol.generator.io.XmlContentResolver;

public class FileWriter {
    public static final FileWriter INSTANCE = new FileWriter();
    private static final List<ContentResolver> CONTENT_RESOLVERS = Arrays.asList(new JsonContentResolver(), new XmlContentResolver());

    private FileWriter() {
    }

    public void writeToFile(Path path, byte[] content, String contentType) throws IOException {
        boolean foundResolver = false;
        for (ContentResolver contentResolver : CONTENT_RESOLVERS) {
            if (!contentResolver.supportsContentType(contentType)) continue;
            Files.write(path, contentResolver.resolveContent(content), new OpenOption[0]);
            foundResolver = true;
            break;
        }
        if (!foundResolver) {
            throw new UnknownContentTypeException("Content-type is unknown:[" + contentType + "]");
        }
    }
}

