/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.rodnansol.generator.ResourceGeneratorParams;
import org.rodnansol.generator.io.FileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileOutputResourceGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileOutputResourceGenerator.class);
    protected final String outputDirectory;

    protected AbstractFileOutputResourceGenerator(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void generateResources(ResourceGeneratorParams params) throws IOException {
        String operation = params.getOperation();
        String contentType = params.getContentType();
        byte[] content = params.getContent();
        if (content == null || content.length == 0) {
            LOGGER.debug("Content is empty, no file is going to be generated");
            return;
        }
        int status = params.getStatus();
        this.createFolderIfNeeded();
        Path file = this.getFile(operation, status, contentType, params.getName(), params.getDescription());
        FileWriter.INSTANCE.writeToFile(file, content, contentType);
    }

    protected abstract String createFilePath(String var1, int var2, String var3, String var4, String var5);

    protected String getFolderName() {
        return this.outputDirectory + "/";
    }

    private void createFolderIfNeeded() {
        String folderName = this.getFolderName();
        File folder = Paths.get(folderName, new String[0]).toFile();
        folder.mkdirs();
    }

    private Path getFile(String operation, int status, String contentType, String name, String optionalDescription) throws IOException {
        String aggregatorFile = this.createFilePath(operation, status, contentType, name, optionalDescription);
        Path file = Paths.get(aggregatorFile, new String[0]);
        if (!file.toFile().exists()) {
            LOGGER.debug("File does not exist, creating it:[{}]", (Object)aggregatorFile);
            file = Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }
}

