/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.rodnansol.FileWriter;
import org.rodnansol.ResourceGeneratorParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileOutputResourceGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileOutputResourceGenerator.class);

    void generateResources(ResourceGeneratorParams params) throws IOException {
        String operation = params.getOperation();
        String contentType = params.getContentType();
        byte[] content = params.getContent();
        if (content == null || content.length == 0) {
            LOGGER.debug("Content is empty, no file is going to be generated");
            return;
        }
        int status = params.getStatus();
        String folderName = this.getFolderName(operation);
        File folder = Paths.get(folderName, new String[0]).toFile();
        folder.mkdirs();
        String aggregatorFile = this.createAggregatorFile(operation, params.getDescription(), status, contentType);
        Path file = Paths.get(aggregatorFile, new String[0]);
        if (!file.toFile().exists()) {
            file = Files.createFile(file, new FileAttribute[0]);
        }
        FileWriter.INSTANCE.writeToFile(file, content, contentType);
    }

    protected abstract String createAggregatorFile(String var1, String var2, int var3, String var4);

    protected abstract String getFolderName(String var1);
}

