/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol;

import org.rodnansol.AbstractFileOutputResourceGenerator;
import org.rodnansol.MediaTypeUtil;
import org.rodnansol.ResourceGeneratorParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyExampleFileOutputResourceGenerator
extends AbstractFileOutputResourceGenerator {
    private static final String OPENAPI_EXTENDER_REQUEST_FOLDER = "openapi-extender/requests/";
    static final String DEFAULT_OUTPUT_DIRECTORY = "target/classes/openapi-extender/requests/";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestBodyExampleFileOutputResourceGenerator.class);
    private final String outputDirectory;

    public RequestBodyExampleFileOutputResourceGenerator() {
        this(DEFAULT_OUTPUT_DIRECTORY);
    }

    public RequestBodyExampleFileOutputResourceGenerator(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected String createAggregatorFile(String operation, String description, int status, String contentType) {
        return this.getFolderName(operation) + status + "_" + description + MediaTypeUtil.MEDIA_TYPES.get(contentType);
    }

    @Override
    protected String getFolderName(String operation) {
        return this.outputDirectory + operation + "/";
    }

    static class Params
    implements ResourceGeneratorParams {
        private final String operation;
        private final String description;
        private final int status;
        private final String contentType;
        private final byte[] content;

        public Params(String operation, String description, int status, String contentType, byte[] content) {
            this.operation = operation;
            this.description = description;
            this.status = status;
            this.contentType = contentType;
            this.content = content;
        }

        @Override
        public String getOperation() {
            return this.operation;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }
    }
}

