/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.motion_speech;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceLifecycle;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceParams;
import org.robokind.api.motion.Robot;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerConfig;
import org.robokind.impl.speech.viseme.VisemeBindingManagerAvroConfigLoader;
import org.robokind.impl.speech.viseme.VisemeBindingManagerConfigAvroStreamLoader;
import org.robokind.integration.motion_speech.VisemeFrameSourceLifecycle;

public class VisemeMotionUtils {
    public static ManagedServiceGroup startVisemeFrameSourceGroup(ManagedServiceFactory fact, Robot.Id robotId, String speechServiceId, String visemeConfigPath) {
        String groupId = "viseme/" + robotId.getRobtIdString() + "/" + speechServiceId;
        ManagedServiceGroup group = new ManagedServiceGroup(fact, VisemeMotionUtils.getLifecycles(groupId, robotId, speechServiceId, visemeConfigPath), groupId, null);
        group.start();
        return group;
    }

    private static List<ServiceLifecycleProvider> getLifecycles(String groupId, Robot.Id robotId, String speechServiceId, String visemeConfigPath) {
        String configFileId = groupId + "/config/avro";
        return Arrays.asList(VisemeMotionUtils.getBindingConfigLifecycle(configFileId, new File(visemeConfigPath)), VisemeMotionUtils.getBindingManagerLifecycle(robotId, speechServiceId, configFileId), VisemeMotionUtils.getVisemeFrameSourceLifecycle(robotId, speechServiceId));
    }

    private static ServiceLifecycleProvider getBindingManagerLifecycle(Robot.Id robotId, String speechServiceId, String configFileId) {
        ConfiguredServiceParams params = new ConfiguredServiceParams(VisemeBindingManager.class, VisemeBindingManagerConfig.class, File.class, null, null, configFileId, VisemeBindingManager.VERSION, VisemeBindingManagerAvroConfigLoader.VERSION);
        Properties registrationProps = new Properties();
        registrationProps.put("robotId", robotId.getRobtIdString());
        registrationProps.put("speechServiceId", speechServiceId);
        ConfiguredServiceLifecycle lifecycle = new ConfiguredServiceLifecycle(params, registrationProps);
        return lifecycle;
    }

    private static ServiceLifecycleProvider getBindingConfigLifecycle(String paramId, File file) {
        Properties props = new Properties();
        props.put("configParamId", paramId);
        props.put("configFormatVersion", VisemeBindingManagerAvroConfigLoader.VERSION.toString());
        props.put("FilePath", file.getAbsolutePath());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)file, File.class, props);
        return lifecycle;
    }

    private static ServiceLifecycleProvider getVisemeFrameSourceLifecycle(Robot.Id robotId, String speechServiceId) {
        return new VisemeFrameSourceLifecycle(robotId, speechServiceId);
    }

    public static String getNetBeansRootPath() {
        String dir;
        String dir2;
        String brandingToken = "robokindcontroller";
        String cluster = "robokind";
        File f = new File("./");
        String path = f.getAbsolutePath();
        int len = path.length();
        if (len >= 5 && (dir2 = path.substring(len - 5, len - 2).toLowerCase()).equals("bin")) {
            return "../" + cluster + "/";
        }
        int blen = brandingToken.length() + 2;
        if (len >= blen && (dir = path.substring(len - blen, len - 2).toLowerCase()).equals(brandingToken)) {
            return "./" + cluster + "/";
        }
        return "./target/" + brandingToken + "/" + cluster + "/";
    }

    private static ServiceLifecycleProvider getBindingManagerStreamLifecycle(Robot.Id robotId, String speechServiceId, String configFileId) {
        ConfiguredServiceParams params = new ConfiguredServiceParams(VisemeBindingManager.class, VisemeBindingManagerConfig.class, InputStream.class, null, null, configFileId, VisemeBindingManager.VERSION, VisemeBindingManagerConfigAvroStreamLoader.VERSION);
        Properties registrationProps = new Properties();
        registrationProps.put("robotId", robotId.getRobtIdString());
        registrationProps.put("speechServiceId", speechServiceId);
        ConfiguredServiceLifecycle lifecycle = new ConfiguredServiceLifecycle(params, registrationProps);
        return lifecycle;
    }

    public static ManagedServiceGroup startVisemeFrameSourceStreamGroup(ManagedServiceFactory fact, Robot.Id robotId, String speechServiceId, InputStream visemeConfigStream) {
        String groupId = "viseme/" + robotId.getRobtIdString() + "/" + speechServiceId;
        ManagedServiceGroup group = new ManagedServiceGroup(fact, VisemeMotionUtils.getStreamLifecycles(groupId, robotId, speechServiceId, visemeConfigStream), groupId, null);
        group.start();
        return group;
    }

    private static List<ServiceLifecycleProvider> getStreamLifecycles(String groupId, Robot.Id robotId, String speechServiceId, InputStream visemeConfigStream) {
        String configFileId = groupId + "/config/avro";
        return Arrays.asList(VisemeMotionUtils.getBindingConfigStreamLifecycle(configFileId, visemeConfigStream), VisemeMotionUtils.getBindingManagerStreamLifecycle(robotId, speechServiceId, configFileId), VisemeMotionUtils.getVisemeFrameSourceLifecycle(robotId, speechServiceId));
    }

    private static ServiceLifecycleProvider getBindingConfigStreamLifecycle(String paramId, InputStream stream) {
        Properties props = new Properties();
        props.put("configParamId", paramId);
        props.put("configFormatVersion", VisemeBindingManagerConfigAvroStreamLoader.VERSION.toString());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)stream, InputStream.class, props);
        return lifecycle;
    }
}

