/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.motion_speech;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.VisemeEventNotifier;
import org.robokind.integration.motion_speech.VisemeFrameSource;

public class VisemeFrameSourceLifecycle
extends AbstractLifecycleProvider<FrameSource, VisemeFrameSource> {
    private static final String theVisemeNotifier = "speechService";
    private static final String theVisemeManager = "visemeManager";
    private Robot.Id myRobotId;
    private VisemeEventNotifier myNotifier;

    public VisemeFrameSourceLifecycle(Robot.Id robotId, String speechServiceId) {
        super(new DescriptorListBuilder().dependency(theVisemeNotifier, VisemeEventNotifier.class).with("speechServiceId", speechServiceId).dependency(theVisemeManager, VisemeBindingManager.class).with("robotId", robotId.getRobtIdString()).getDescriptors());
        if (robotId == null || speechServiceId == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("robotId", this.myRobotId);
    }

    protected VisemeFrameSource create(Map<String, Object> services) {
        this.myNotifier = (VisemeEventNotifier)services.get(theVisemeNotifier);
        VisemeBindingManager viseme = (VisemeBindingManager)services.get(theVisemeManager);
        VisemeFrameSource vfs = new VisemeFrameSource(this.myRobotId, viseme);
        this.myNotifier.addListener(vfs.getVisemeListener());
        return vfs;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (this.myNotifier != null && this.myService != null) {
            this.myNotifier.removeListener(((VisemeFrameSource)this.myService).getVisemeListener());
        }
        if (theVisemeManager.equals(serviceId)) {
            if (service == null) {
                if (this.myService != null) {
                    this.myService = null;
                }
                return;
            }
            this.myService = new VisemeFrameSource(this.myRobotId, (VisemeBindingManager)service);
        } else if (theVisemeNotifier.equals(serviceId)) {
            this.myNotifier = (VisemeEventNotifier)service;
        }
        if (this.myNotifier != null && this.myService != null) {
            this.myNotifier.addListener(((VisemeFrameSource)this.myService).getVisemeListener());
        }
    }

    public Class<FrameSource> getServiceClass() {
        return FrameSource.class;
    }
}

