/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.motion_speech;

import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.osgi.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.lifecycle.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.VisemeEventNotifier;
import org.robokind.integration.motion_speech.VisemeFrameSource;

public class VisemeFrameSourceLifecycleProvider
extends AbstractLifecycleProvider<FrameSource, VisemeFrameSource> {
    private static final String theDepVisemeNotifier = "speechService";
    private static final String theDepVisemeManager = "visemeManager";
    private Robot.Id myRobotId;
    private VisemeEventNotifier myNotifier;

    public VisemeFrameSourceLifecycleProvider(Robot.Id robotId, String speechServiceId) {
        super(new DescriptorListBuilder().addId(theDepVisemeNotifier, VisemeEventNotifier.class, "speechServiceId", speechServiceId).addId(theDepVisemeManager, VisemeBindingManager.class, "robotId", robotId.getRobtIdString()).getDescriptors());
        if (robotId == null || speechServiceId == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("robotId", this.myRobotId);
    }

    protected VisemeFrameSource create(Map<String, Object> services) {
        this.myNotifier = (VisemeEventNotifier)services.get(theDepVisemeNotifier);
        VisemeBindingManager viseme = (VisemeBindingManager)services.get(theDepVisemeManager);
        VisemeFrameSource vfs = new VisemeFrameSource(this.myRobotId, viseme);
        this.myNotifier.addListener(vfs.getVisemeListener());
        return vfs;
    }

    protected void handleChange(String serviceId, Object service) {
    }

    public Class<FrameSource> getServiceClass() {
        return FrameSource.class;
    }
}

