/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.integration.motion_speech;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.speech.viseme.Viseme;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.VisemeEvent;

public class VisemeFrameSource
implements FrameSource<Robot.RobotPositionMap> {
    private static final Logger theLogger = Logger.getLogger(VisemeFrameSource.class.getName());
    private Robot.Id myRobotId;
    private VisemeBindingManager myVisemeManager;
    private Robot.RobotPositionMap myStartPositions;
    private Robot.RobotPositionMap myGoalPositions;
    private Integer myCurrentMoveLength;
    private Long myCurrentMoveStart;
    private Map<Viseme, Robot.RobotPositionMap> myVisemePositions;
    private VisemeListener myListener;
    private final Object myMoveLock;

    public VisemeFrameSource(Robot.Id robotId, VisemeBindingManager visemeManager) {
        if (robotId == null || visemeManager == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myVisemeManager = visemeManager;
        this.cacheAllVisemePositions();
        this.myListener = new VisemeListener();
        this.myMoveLock = new Object();
    }

    private void cacheAllVisemePositions() {
        this.myVisemePositions = new EnumMap<Viseme, Robot.RobotPositionMap>(Viseme.class);
        for (Viseme viseme : Viseme.values()) {
            this.cacheVisemePositions(viseme);
        }
    }

    private void cacheVisemePositions(Viseme viseme) {
        Map vals = this.myVisemeManager.getBindingValues(viseme);
        if (vals == null) {
            theLogger.log(Level.WARNING, "Missing Viseme Binding for: {0}", viseme.name());
            return;
        }
        Robot.RobotPositionMap map = this.convertVisemeValues(vals);
        this.myVisemePositions.put(viseme, map);
    }

    private Robot.RobotPositionMap convertVisemeValues(Map<Integer, NormalizedDouble> values) {
        Robot.RobotPositionHashMap map = new Robot.RobotPositionHashMap(values.size());
        for (Map.Entry<Integer, NormalizedDouble> e : values.entrySet()) {
            map.put((Object)this.jointId(e.getKey()), (Object)e.getValue());
        }
        return map;
    }

    private Robot.JointId jointId(int id) {
        Joint.Id jId = new Joint.Id(id);
        return new Robot.JointId(this.myRobotId, jId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MotionFrame<Robot.RobotPositionMap> getMovements(long currentTimeUTC, long moveLengthMilliSec) {
        Object object = this.myMoveLock;
        synchronized (object) {
            return this.getFrameUnsafe(currentTimeUTC, moveLengthMilliSec);
        }
    }

    private MotionFrame getFrameUnsafe(long currentTimeUTC, long moveLengthMilliSec) {
        if (this.myStartPositions == null || this.myGoalPositions == null || this.myCurrentMoveStart == null || this.myCurrentMoveLength == null) {
            return null;
        }
        double startMillisec = currentTimeUTC - this.myCurrentMoveStart;
        startMillisec = Math.max(0.0, startMillisec);
        double stopMillisec = startMillisec + (double)moveLengthMilliSec;
        stopMillisec = Utils.bound((double)stopMillisec, (double)(startMillisec + 1.0), (double)this.myCurrentMoveLength.intValue());
        double startPercent = startMillisec / (double)this.myCurrentMoveLength.intValue();
        startPercent = Utils.bound((double)startPercent, (double)0.0, (double)1.0);
        double stopPercent = stopMillisec / (double)this.myCurrentMoveLength.intValue();
        stopPercent = Utils.bound((double)stopPercent, (double)0.0, (double)1.0);
        DefaultMotionFrame frame = new DefaultMotionFrame();
        frame.setFrameLengthMillisec(moveLengthMilliSec);
        frame.setTimestampMillisecUTC(currentTimeUTC);
        frame.setPreviousPositions((JointPositionMap)new Robot.RobotPositionHashMap());
        frame.setGoalPositions((JointPositionMap)new Robot.RobotPositionHashMap());
        for (Robot.JointId jId : this.myStartPositions.keySet()) {
            this.addJoint(jId, (MotionFrame)frame, startPercent, stopPercent);
        }
        if (currentTimeUTC >= this.myCurrentMoveStart + (long)this.myCurrentMoveLength.intValue()) {
            // empty if block
        }
        return frame;
    }

    private void addJoint(Robot.JointId jointId, MotionFrame frame, double startPercent, double stopPercent) {
        NormalizedDouble normAbsStart = (NormalizedDouble)this.myStartPositions.get((Object)jointId);
        NormalizedDouble normAbsStop = (NormalizedDouble)this.myGoalPositions.get((Object)jointId);
        if (normAbsStart == null || normAbsStop == null) {
            return;
        }
        double absStart = normAbsStart.getValue();
        double absStop = normAbsStop.getValue();
        double range = absStop - absStart;
        double start = startPercent * range + absStart;
        start = Utils.bound((double)start, (double)0.0, (double)1.0);
        double stop = stopPercent * range + absStart;
        stop = Utils.bound((double)stop, (double)0.0, (double)1.0);
        frame.getPreviousPositions().put((Object)jointId, (Object)new NormalizedDouble(start));
        frame.getGoalPositions().put((Object)jointId, (Object)new NormalizedDouble(stop));
    }

    private void cleanup() {
        this.myStartPositions = null;
        this.myGoalPositions = null;
        this.myCurrentMoveLength = null;
        this.myCurrentMoveStart = null;
    }

    public Listener<VisemeEvent> getVisemeListener() {
        return this.myListener;
    }

    class VisemeListener
    implements Listener<VisemeEvent> {
        VisemeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(VisemeEvent event) {
            Object object = VisemeFrameSource.this.myMoveLock;
            synchronized (object) {
                VisemeFrameSource.this.myStartPositions = (Robot.RobotPositionMap)VisemeFrameSource.this.myVisemePositions.get(event.getCurrentViseme());
                VisemeFrameSource.this.myGoalPositions = (Robot.RobotPositionMap)VisemeFrameSource.this.myVisemePositions.get(event.getNextViseme());
                VisemeFrameSource.this.myCurrentMoveStart = TimeUtils.now();
                VisemeFrameSource.this.myCurrentMoveLength = event.getDuration();
            }
        }
    }
}

