/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.integration.motion_speech;

import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.lifecycle.DescriptorListBuilder;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.speech.SpeechService;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.VisemeEventNotifier;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class VisemeFrameSourceLifecycleProvider extends 
        AbstractLifecycleProvider<FrameSource, VisemeFrameSource> {
    private final static String theDepVisemeNotifier = "speechService";
    private final static String theDepVisemeManager = "visemeManager";
    private Robot.Id myRobotId;
    private VisemeEventNotifier myNotifier;
    
    public VisemeFrameSourceLifecycleProvider(
            Robot.Id robotId, String speechServiceId){
        super(new DescriptorListBuilder()
                .addId(theDepVisemeNotifier, VisemeEventNotifier.class, 
                        SpeechService.PROP_ID, speechServiceId)
                .addId(theDepVisemeManager, VisemeBindingManager.class, 
                        Robot.PROP_ID, robotId.getRobtIdString())
                .getDescriptors());
        if(robotId == null || speechServiceId == null){
            throw new NullPointerException();
        }
        myRobotId = robotId;
        myRegistrationProperties = new Properties();
        myRegistrationProperties.put(
                Robot.PROP_ID, myRobotId);
    }

    @Override
    protected VisemeFrameSource create(Map<String, Object> services) {
        myNotifier = (VisemeEventNotifier)services.get(theDepVisemeNotifier);
        VisemeBindingManager viseme = 
                (VisemeBindingManager)services.get(theDepVisemeManager);
        VisemeFrameSource vfs = 
                new VisemeFrameSource(myRobotId, viseme);
        myNotifier.addListener(vfs.getVisemeListener());
        return vfs;
    }

    @Override
    protected void handleChange(String serviceId, Object service) {
    }

    @Override
    public Class<FrameSource> getServiceClass() {
        return FrameSource.class;
    }
    
}
