/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.integration.motion_speech;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.lifecycle.DynamicServiceLauncher;
import org.robokind.api.motion.Robot;
import org.robokind.api.speech.viseme.VisemeBindingManager;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerServiceFactory;
import org.robokind.avrogen.speech.viseme.VisemeBindingManagerConfigRecord;
import org.robokind.bind.apache_avro.AvroUtils;
import org.robokind.impl.speech.viseme.PortableVisemeBindingManagerConfig;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Activator implements BundleActivator {
    private final static Logger theLogger = 
            Logger.getLogger(Activator.class.getName());
    
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "Speech-Motion integration Activation Begin.");
        /*VisemeBindingManagerConfigRecord mgmt = AvroUtils.readFromFile(
                VisemeBindingManagerConfigRecord.class,
                null,
                VisemeBindingManagerConfigRecord.SCHEMA$, 
		 		// Matt's version
                new File("/home/matt/Desktop/VisemeConf.json"), true);
		        // Stu's version
				// new File("P:\\_prj\\robo\\_global\\VisemeConf.json"), true);
        PortableVisemeBindingManagerConfig mngrConf = 
                new PortableVisemeBindingManagerConfig(mgmt);
        VisemeBindingManager mngr = 
                new VisemeBindingManagerServiceFactory()
                        .buildVisemeBindingManager(mngrConf);
        Robot.Id id = new Robot.Id("myRobot");
        Properties props = new Properties();
        props.put(Robot.PROP_ID, id.getRobtIdString());
        context.registerService(
                VisemeBindingManager.class.getName(), mngr, props);
        new DynamicServiceLauncher(context,
                new VisemeFrameSourceLifecycleProvider(
                        new Robot.Id("myRobot"), "speechService")).start();*/
        theLogger.log(Level.INFO, "Speech-Motion integration Activation Complete.");
    }
    
    public void stop(BundleContext context) throws Exception {
        //TODO add deactivation code here
    }
}
