/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.robokind.api.animation.editor.features.SyncPointGroupConfig;
import org.robokind.api.animation.editor.features.SynchronizedPointGroup;
import org.robokind.api.animation.xml.AnimationXML;
import org.robokind.extern.utils.apache_commons_configuration.XMLConfigUtils;
import org.xmlpull.v1.XmlSerializer;

public class SyncPointGroupXML {

    public static class ApacheReader {
        static List<SyncPointGroupConfig.SyncGroupConfig> readSyncPointGroupConfigs(HierarchicalConfiguration conf) {
            List nodes = conf.configurationsAt("SyncPointGroup");
            if (nodes == null || nodes.isEmpty()) {
                return null;
            }
            ArrayList<SyncPointGroupConfig.SyncGroupConfig> groups = new ArrayList<SyncPointGroupConfig.SyncGroupConfig>(nodes.size());
            for (HierarchicalConfiguration node : nodes) {
                SyncPointGroupConfig.SyncGroupConfig group = ApacheReader.readSyncPointGroup(node);
                if (group == null) continue;
                groups.add(group);
            }
            return groups;
        }

        static SyncPointGroupConfig.SyncGroupConfig readSyncPointGroup(HierarchicalConfiguration conf) {
            List nodes = conf.configurationsAt("SyncPoint");
            if (nodes == null || nodes.isEmpty()) {
                return null;
            }
            ArrayList<SyncPointGroupConfig.SyncPointConfig> points = new ArrayList<SyncPointGroupConfig.SyncPointConfig>(nodes.size());
            for (HierarchicalConfiguration node : nodes) {
                SyncPointGroupConfig.SyncPointConfig point = ApacheReader.readSyncPointConfig(node);
                if (point == null) continue;
                points.add(point);
            }
            if (points.isEmpty()) {
                return null;
            }
            return new SyncPointGroupConfig.SyncGroupConfig(points);
        }

        static SyncPointGroupConfig.SyncPointConfig readSyncPointConfig(HierarchicalConfiguration conf) {
            int chanId = conf.getInt("ChannelId", -1);
            int pathId = conf.getInt("MotionPathId", -1);
            int pointId = conf.getInt("ControlPointId", -1);
            if (chanId < 0 || pathId < 0 || pointId < 0) {
                return null;
            }
            return new SyncPointGroupConfig.SyncPointConfig(chanId, pathId, pointId);
        }
    }

    public static class ApacheWriter {
        static ConfigurationNode writeSyncGroups(Set<SynchronizedPointGroup> pointGroups) {
            ConfigurationNode node = XMLConfigUtils.node((String)"SyncPointGroups");
            if (pointGroups == null) {
                return node;
            }
            for (SynchronizedPointGroup group : pointGroups) {
                SyncPointGroupConfig.SyncGroupConfig conf = SyncPointGroupConfig.createConfig((SynchronizedPointGroup)group);
                if (conf == null) continue;
                node.addChild(ApacheWriter.writeSyncGroupConfig(conf));
            }
            return node;
        }

        static ConfigurationNode writeSyncGroupConfig(SyncPointGroupConfig.SyncGroupConfig conf) {
            ConfigurationNode node = XMLConfigUtils.node((String)"SyncPointGroup");
            for (SyncPointGroupConfig.SyncPointConfig c : conf.points) {
                node.addChild(ApacheWriter.writeSyncPointConfig(c));
            }
            return node;
        }

        static ConfigurationNode writeSyncPointConfig(SyncPointGroupConfig.SyncPointConfig conf) {
            ConfigurationNode node = XMLConfigUtils.node((String)"SyncPoint");
            node.addChild(XMLConfigUtils.node((String)"ChannelId", (Object)conf.channelId));
            node.addChild(XMLConfigUtils.node((String)"MotionPathId", (Object)conf.motionPathId));
            node.addChild(XMLConfigUtils.node((String)"ControlPointId", (Object)conf.controlPointId));
            return node;
        }
    }

    public static class XPP3Writer {
        static void writeSyncGroups(XmlSerializer xs, Set<SynchronizedPointGroup> pointGroups) throws IOException {
            xs.startTag(AnimationXML.NAMESPACE, "SyncPointGroups");
            if (pointGroups == null) {
                xs.endTag(AnimationXML.NAMESPACE, "SyncPointGroups");
                return;
            }
            for (SynchronizedPointGroup group : pointGroups) {
                SyncPointGroupConfig.SyncGroupConfig conf = SyncPointGroupConfig.createConfig((SynchronizedPointGroup)group);
                if (conf == null) continue;
                XPP3Writer.writeSyncGroupConfig(xs, conf);
            }
            xs.endTag(AnimationXML.NAMESPACE, "SyncPointGroups");
        }

        static void writeSyncGroupConfig(XmlSerializer xs, SyncPointGroupConfig.SyncGroupConfig conf) throws IOException {
            xs.startTag(AnimationXML.NAMESPACE, "SyncPointGroup");
            for (SyncPointGroupConfig.SyncPointConfig pointConf : conf.points) {
                XPP3Writer.writeSyncPointConfig(xs, pointConf);
            }
            xs.endTag(AnimationXML.NAMESPACE, "SyncPointGroup");
        }

        static void writeSyncPointConfig(XmlSerializer xs, SyncPointGroupConfig.SyncPointConfig conf) throws IOException {
            xs.startTag(AnimationXML.NAMESPACE, "SyncPoint");
            XPP3Writer.tag(xs, AnimationXML.NAMESPACE, "ChannelId", conf.channelId);
            XPP3Writer.tag(xs, AnimationXML.NAMESPACE, "MotionPathId", conf.motionPathId);
            XPP3Writer.tag(xs, AnimationXML.NAMESPACE, "ControlPointId", conf.controlPointId);
            xs.endTag(AnimationXML.NAMESPACE, "SyncPoint");
        }

        static void tag(XmlSerializer xs, String namespace, String tag, Object val) throws IOException {
            xs.startTag(namespace, tag);
            xs.text(val.toString());
            xs.endTag(namespace, tag);
        }
    }
}

