/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.xml;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.services.addon.AddOnUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;
import org.robokind.extern.utils.apache_commons_configuration.XMLConfigUtils;

public class ApacheAnimationXMLWriter
implements AnimationFileWriter {
    private static final Logger theLogger = Logger.getLogger(ApacheAnimationXMLWriter.class.getName());

    public void writeAnimation(String path, Animation anim) throws Exception {
        ApacheAnimationXMLWriter.saveAnimation(path, anim);
    }

    static void saveAnimation(String path, Animation anim) throws ConfigurationException {
        if (path == null || path.isEmpty() || anim == null) {
            return;
        }
        XMLConfiguration config = ApacheAnimationXMLWriter.writeAnimation(anim, path);
        config.save(path);
    }

    public static XMLConfiguration writeAnimation(Animation anim, String path) {
        XMLConfiguration config = new XMLConfiguration();
        config.setRootElementName("Animation");
        ConfigurationNode node = config.getRootNode();
        node.addChild(XMLConfigUtils.writeVersion((VersionProperty)anim.getVersion(), (String)"Animation"));
        node.addChild(ApacheAnimationXMLWriter.writeChannels(anim.getChannels()));
        node.addChild(ApacheAnimationXMLWriter.writeAddOnList(anim.getAddOns(), path));
        return config;
    }

    public static ConfigurationNode writeChannels(List<Channel> channels) {
        ConfigurationNode node = XMLConfigUtils.node((String)"Channels");
        if (channels == null) {
            return node;
        }
        for (Channel channel : channels) {
            node.addChild(ApacheAnimationXMLWriter.writeChannel(channel));
        }
        return node;
    }

    public static ConfigurationNode writeChannel(Channel channel) {
        if (channel == null) {
            return null;
        }
        ConfigurationNode node = XMLConfigUtils.node((String)"Channel");
        node.addAttribute(XMLConfigUtils.node((String)"id", (Object)channel.getId()));
        String name = channel.getName();
        if (name != null && !name.isEmpty()) {
            node.addAttribute(XMLConfigUtils.node((String)"name", (Object)name));
        }
        node.addChild(ApacheAnimationXMLWriter.writeMotionPaths(channel.getMotionPaths()));
        return node;
    }

    public static ConfigurationNode writeMotionPaths(List<MotionPath> paths) {
        ConfigurationNode node = XMLConfigUtils.node((String)"MotionPaths");
        if (paths == null || paths.isEmpty()) {
            return node;
        }
        for (MotionPath path : paths) {
            ConfigurationNode pNode = ApacheAnimationXMLWriter.writeMotionPath(path);
            if (pNode == null) continue;
            node.addChild(pNode);
        }
        return node;
    }

    public static ConfigurationNode writeMotionPath(MotionPath mp) {
        if (mp == null) {
            return null;
        }
        ConfigurationNode node = XMLConfigUtils.node((String)"MotionPath");
        String name = mp.getName();
        if (name != null && !name.isEmpty()) {
            node.addAttribute(XMLConfigUtils.node((String)"name", (Object)name));
        }
        node.addChild(XMLConfigUtils.writeVersion((VersionProperty)mp.getInterpolatorVersion(), (String)"Interpolation"));
        node.addChild(ApacheAnimationXMLWriter.writeControlPoints(mp.getControlPoints()));
        return node;
    }

    public static ConfigurationNode writeControlPoints(List<Point2D> points) {
        ConfigurationNode node = XMLConfigUtils.node((String)"ControlPoints");
        for (Point2D p : points) {
            ConfigurationNode child = ApacheAnimationXMLWriter.writeControlPoint(p);
            if (child == null) continue;
            node.addChild(child);
        }
        return node;
    }

    public static ConfigurationNode writeControlPoint(Point2D p) {
        if (p == null) {
            return null;
        }
        ConfigurationNode node = XMLConfigUtils.node((String)"ControlPoint");
        node.addChild(XMLConfigUtils.node((String)"Time", (Object)p.getX()));
        node.addChild(XMLConfigUtils.node((String)"Position", (Object)p.getY()));
        return node;
    }

    public static ConfigurationNode writeAddOnList(List<ServiceAddOn<Playable>> addons, String animPath) {
        if (addons == null || animPath == null) {
            throw new NullPointerException();
        }
        ConfigurationNode node = XMLConfigUtils.node((String)"AddOns");
        int addonCount = 0;
        for (ServiceAddOn<Playable> addon : addons) {
            ConfigurationNode addonNode;
            String addonPath = animPath + ".addon." + addonCount + ".conf";
            try {
                addonNode = ApacheAnimationXMLWriter.writeAddOn(addon, addonPath);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Error writing AddOn.", ex);
                continue;
            }
            if (addonNode == null) continue;
            node.addChild(addonNode);
            ++addonCount;
        }
        return node;
    }

    public static ConfigurationNode writeAddOn(ServiceAddOn<Playable> addon, String addonPath) throws Exception {
        if (addon == null || addonPath == null) {
            return null;
        }
        ServiceAddOnDriver driver = addon.getAddOnDriver();
        if (driver == null) {
            throw new NullPointerException();
        }
        if (!AddOnUtils.saveAddOnConfig(addon, (String)addonPath)) {
            return null;
        }
        ConfigurationNode node = XMLConfigUtils.node((String)"AddOn");
        node.addChild(XMLConfigUtils.writeVersion((VersionProperty)driver.getServiceVersion(), (String)"ServiceVersion"));
        node.addChild(XMLConfigUtils.writeVersion((VersionProperty)driver.getConfigurationFormat(), (String)"configFormatVersion"));
        node.addChild(XMLConfigUtils.node((String)"AddOnFile", (Object)addonPath));
        return node;
    }
}

