/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.xml;

import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.xml.AnimationFileReader;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.services.addon.AddOnUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;
import org.robokind.api.interpolation.InterpolatorDirectory;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.robokind.extern.utils.apache_commons_configuration.XMLConfigUtils;

public class AnimationXMLReader
implements AnimationFileReader {
    private static final Logger theLogger = Logger.getLogger(AnimationXMLReader.class.getName());

    public Animation readAnimation(String path) throws Exception {
        return AnimationXMLReader.loadAnimation(path);
    }

    static Animation loadAnimation(String path) throws ConfigurationException, Exception {
        Animation anim = null;
        try {
            XMLConfiguration config = new XMLConfiguration(path);
            anim = AnimationXMLReader.readAnimation((HierarchicalConfiguration)config);
            return anim;
        }
        catch (ConfigurationException t) {
            theLogger.log(Level.WARNING, "Cannont open XML file at: " + path, t);
            throw t;
        }
        catch (Exception t) {
            theLogger.log(Level.SEVERE, "There was an error reading your animation.", t);
            throw t;
        }
    }

    public static Animation readAnimation(HierarchicalConfiguration config) {
        VersionProperty version = XMLConfigUtils.readVersion((HierarchicalConfiguration)config, (String)"Animation");
        Animation anim = new Animation(version);
        SubnodeConfiguration channelsConfig = config.configurationAt("Channels");
        if (channelsConfig != null && !channelsConfig.isEmpty()) {
            anim.addChannels(AnimationXMLReader.readChannels((HierarchicalConfiguration)channelsConfig));
        }
        if (config.containsKey("AddOns")) {
            SubnodeConfiguration addonsConfig = config.configurationAt("AddOns");
            List<ServiceAddOn<Playable>> addons = AnimationXMLReader.readAddOns((HierarchicalConfiguration)addonsConfig);
            for (ServiceAddOn<Playable> addon : addons) {
                anim.addAddOn(addon);
            }
        }
        return anim;
    }

    public static List<Channel> readChannels(HierarchicalConfiguration config) {
        List nodes = config.configurationsAt("Channel");
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(nodes.size());
        for (HierarchicalConfiguration node : nodes) {
            Channel channel = AnimationXMLReader.readChannel(node);
            if (channel == null) continue;
            channels.add(channel);
        }
        return channels;
    }

    public static Channel readChannel(HierarchicalConfiguration config) {
        Integer id = XMLConfigUtils.getIntegerAttribute((AbstractConfiguration)config, (String)"id", null);
        if (id == null) {
            theLogger.log(Level.WARNING, "Unable to find id attribute for Channel, using -1.");
            id = -1;
        }
        String name = XMLConfigUtils.getStringAttribute((AbstractConfiguration)config, (String)"name", null);
        Channel channel = new Channel(id.intValue(), name);
        SubnodeConfiguration pathsConfig = config.configurationAt("MotionPaths");
        if (pathsConfig == null || pathsConfig.isEmpty()) {
            return channel;
        }
        List<MotionPath> paths = AnimationXMLReader.readMotionPaths((HierarchicalConfiguration)pathsConfig);
        channel.addPaths(paths);
        return channel;
    }

    public static List<MotionPath> readMotionPaths(HierarchicalConfiguration config) {
        List nodes = config.configurationsAt("MotionPath");
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MotionPath> paths = new ArrayList<MotionPath>(nodes.size());
        for (HierarchicalConfiguration node : nodes) {
            paths.add(AnimationXMLReader.readMotionPath(node));
        }
        return paths;
    }

    public static MotionPath readMotionPath(HierarchicalConfiguration config) {
        String name = XMLConfigUtils.getStringAttribute((AbstractConfiguration)config, (String)"name", null);
        InterpolatorFactory factory = AnimationXMLReader.readInterpolatorVersion(config);
        MotionPath path = new MotionPath(factory);
        path.setName(name);
        SubnodeConfiguration pointsConfig = config.configurationAt("ControlPoints");
        if (pointsConfig != null && !pointsConfig.isEmpty()) {
            path.addPoints(AnimationXMLReader.readControlPoints((HierarchicalConfiguration)pointsConfig));
        }
        return path;
    }

    public static InterpolatorFactory readInterpolatorVersion(HierarchicalConfiguration config) {
        VersionProperty version = XMLConfigUtils.readVersion((HierarchicalConfiguration)config, (String)"Interpolation");
        return InterpolatorDirectory.instance().getFactory(version);
    }

    public static List<Point2D> readControlPoints(HierarchicalConfiguration config) {
        List nodes = config.configurationsAt("ControlPoint");
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>(nodes.size());
        for (HierarchicalConfiguration node : nodes) {
            Point2D point = AnimationXMLReader.readControlPoint(node);
            if (point.getX() < 0.0 || point.getY() < 0.0 || point.getY() > 1.0) continue;
            points.add(point);
        }
        return points;
    }

    public static Point2D readControlPoint(HierarchicalConfiguration config) {
        double x = config.getDouble("Time", -1.0);
        double y = config.getDouble("Position", -1.0);
        return new Point2D.Double(x, y);
    }

    public static List<ServiceAddOn<Playable>> readAddOns(HierarchicalConfiguration config) {
        if (config == null) {
            return Collections.EMPTY_LIST;
        }
        List nodes = config.configurationsAt("AddOn");
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        BundleContext context = OSGiUtils.getBundleContext(ServiceAddOnDriver.class);
        if (context == null) {
            throw new NullPointerException();
        }
        ServiceReference[] refs = AddOnUtils.getAddOnDriverReferences((BundleContext)context);
        List<ServiceAddOnDriver<Playable>> drivers = AnimationXMLReader.getAddOnDrivers(context, refs);
        ArrayList<ServiceAddOn<Playable>> addons = new ArrayList<ServiceAddOn<Playable>>(nodes.size());
        for (HierarchicalConfiguration node : nodes) {
            ServiceAddOn<Playable> addon = AnimationXMLReader.readAddOn(node, drivers);
            if (addon == null) continue;
            addons.add(addon);
        }
        return addons;
    }

    public static List<ServiceAddOnDriver<Playable>> getAddOnDrivers(BundleContext context, ServiceReference[] refs) {
        ArrayList<ServiceAddOnDriver<Playable>> drivers = new ArrayList<ServiceAddOnDriver<Playable>>();
        List allDrivers = AddOnUtils.getAddOnDriverList((BundleContext)context, (ServiceReference[])refs);
        for (ServiceAddOnDriver driver : allDrivers) {
            Class addonClass = driver.getServiceClass();
            if (!Playable.class.isAssignableFrom(addonClass)) continue;
            drivers.add((ServiceAddOnDriver<Playable>)driver);
        }
        return drivers;
    }

    public static ServiceAddOn<Playable> readAddOn(HierarchicalConfiguration config, List<ServiceAddOnDriver<Playable>> drivers) {
        Map vers = XMLConfigUtils.readVersions((HierarchicalConfiguration)config, (String[])new String[]{"ServiceVersion", "configFormatVersion"});
        VersionProperty serviceVers = (VersionProperty)vers.get("ServiceVersion");
        VersionProperty configFormat = (VersionProperty)vers.get("configFormatVersion");
        String path = config.getString("AddOnFile");
        if (serviceVers == null || configFormat == null || path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            theLogger.log(Level.WARNING, "Could not find file for AddOn.  File Path: {0}, Service Version: {1}, Config Format: {2}.", new Object[]{path, serviceVers.display(), configFormat.display()});
            return null;
        }
        ServiceAddOnDriver<Playable> driver = AnimationXMLReader.getDriver(serviceVers, configFormat, drivers);
        if (driver == null) {
            theLogger.log(Level.WARNING, "Could not find ServiceAddOnDriver.  File Path: {0}, Service Version: {1}, Config Format: {2}.", new Object[]{path, serviceVers.display(), configFormat.display()});
            return null;
        }
        try {
            return driver.loadAddOn(file);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "There was an error loading an AddOn.  File Path: " + path + ", " + "Service Version: " + serviceVers.display() + ", " + "Config Format: " + configFormat.display() + ".", ex);
            return null;
        }
    }

    private static ServiceAddOnDriver<Playable> getDriver(VersionProperty serviceVers, VersionProperty configFormat, List<ServiceAddOnDriver<Playable>> drivers) {
        for (ServiceAddOnDriver<Playable> driver : drivers) {
            if (!serviceVers.equals((Object)driver.getServiceVersion()) || !configFormat.equals((Object)driver.getConfigurationFormat())) continue;
            return driver;
        }
        return null;
    }
}

