/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.messaging.services;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.messaging.services.RemoteServiceClient;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.api.messaging.services.ServiceError;

public class DefaultServiceClient<Conf>
extends AbstractPlayable
implements RemoteServiceClient<Conf> {
    private static final Logger theLogger = Logger.getLogger(DefaultServiceClient.class.getName());
    private MessageSender<ServiceCommand> myCommandSender;
    private MessageSender<Conf> myConfigSender;
    private MessageAsyncReceiver<ServiceError> myErrorReceiver;
    private ServiceCommandFactory myCommandFactory;
    private String myLocalServiceId;
    private String myRemoteServiceId;

    public DefaultServiceClient(String localId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory) {
        if (localId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myLocalServiceId = localId;
        this.myRemoteServiceId = remoteId;
        this.myCommandSender = commandSender;
        this.myConfigSender = configSender;
        this.myErrorReceiver = errorReceiver;
        this.myCommandFactory = commandFactory;
    }

    @Override
    public void initialize(Conf config) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (this.myConfigSender == null) {
            theLogger.warning("Unable to send config, Config Sender is null.");
            return;
        }
        this.myConfigSender.notifyListeners(config);
    }

    public boolean onStart(long time) {
        this.send("start");
        return true;
    }

    public boolean onPause(long time) {
        this.send("pause");
        return true;
    }

    public boolean onResume(long time) {
        this.send("resume");
        return true;
    }

    public boolean onComplete(long time) {
        this.send("stop");
        return true;
    }

    public boolean onStop(long time) {
        this.send("stop");
        return true;
    }

    protected void send(String commandStr) {
        if (this.myCommandSender == null || this.myCommandFactory == null) {
            theLogger.warning("Unable to send command.  Command Sender or Command Factory is null.");
            return;
        }
        ServiceCommand command = this.myCommandFactory.create(this.myLocalServiceId, this.myRemoteServiceId, commandStr);
        theLogger.log(Level.INFO, "Sending Service Command [{0}] - source: {1}, dest: {2}, time: {3}.", new Object[]{command.getCommand(), command.getSourceId(), command.getDestinationId(), command.getTimestampMillisecUTC()});
        this.myCommandSender.notifyListeners((Object)command);
    }

    @Override
    public void setCommandSender(MessageSender<ServiceCommand> sender) {
        this.myCommandSender = sender;
    }

    @Override
    public void setConfigSender(MessageSender<Conf> sender) {
        this.myConfigSender = sender;
    }

    @Override
    public void setErrorReceiver(MessageAsyncReceiver<ServiceError> receiver) {
        this.myErrorReceiver = receiver;
    }

    @Override
    public void setCommandFactory(ServiceCommandFactory factory) {
        this.myCommandFactory = factory;
    }

    @Override
    public String getClientId() {
        return this.myLocalServiceId;
    }

    @Override
    public String getHostId() {
        return this.myRemoteServiceId;
    }
}

