/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.robokind.api.messaging.MessageSender;
import org.robokind.api.messaging.RecordSender;

public class DefaultMessageSender<Msg, Rec>
implements MessageSender<Msg> {
    static final Logger theLogger = Logger.getLogger(DefaultMessageSender.class.getName());
    private List<Listener<Msg>> myListeners = new ArrayList<Listener<Msg>>();
    private Adapter<Msg, Rec> myAdapter;
    protected RecordSender<Rec> myRecordSender;

    public void setRecordSender(RecordSender<Rec> sender) {
        this.myRecordSender = sender;
    }

    public void setAdapter(Adapter<Msg, Rec> adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void notifyListeners(Msg message) {
        Rec record = this.getRecord(message);
        if (record == null) {
            theLogger.warning("Adapter returned null Record, unable to send message.");
            return;
        }
        this.myRecordSender.sendRecord(record);
        this.fireMessageEvent(message);
    }

    protected Rec getRecord(Msg message) {
        if (message == null) {
            throw new NullPointerException();
        }
        if (this.myRecordSender == null) {
            theLogger.warning("No MessageSender, unable to send message.");
            return null;
        }
        if (this.myAdapter == null) {
            theLogger.warning("No Message Adapter, unable to send message.");
            return null;
        }
        return (Rec)this.myAdapter.adapt(message);
    }

    protected void fireMessageEvent(Msg message) {
        for (Listener<Msg> listener : this.myListeners) {
            listener.handleEvent(message);
        }
    }

    @Override
    public void addListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        this.myListeners.remove(listener);
    }

    public void handleEvent(Msg event) {
        this.notifyListeners(event);
    }
}

