/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.RecordAsyncReceiver;

public class DefaultMessageAsyncReceiver<Msg, Rec>
implements MessageAsyncReceiver<Msg> {
    private static final Logger theLogger = Logger.getLogger(DefaultMessageAsyncReceiver.class.getName());
    private RecordAsyncReceiver<Rec> myRecordService;
    private Adapter<Rec, Msg> myAdapter;
    private RecordAdapterHandler myRecordHandler;
    private List<Listener<Msg>> myListeners = new ArrayList<Listener<Msg>>();

    public void setRecordReceiver(RecordAsyncReceiver<Rec> service) {
        if (this.myRecordService != null) {
            this.myRecordService.unsetRecordHandler();
            this.myRecordService.pause();
        }
        this.myRecordService = service;
        if (this.myRecordService != null && this.myRecordHandler == null) {
            this.myRecordHandler = new RecordAdapterHandler();
        }
        this.myRecordService.setRecordHandler(this.myRecordHandler);
    }

    public void setAdapter(Adapter<Rec, Msg> adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void start() throws Exception {
        if (this.myRecordService == null) {
            theLogger.warning("No Record PollingService, unable to start.");
            return;
        }
        if (this.myAdapter == null) {
            theLogger.warning("No Record Adapter, unable to start.");
            return;
        }
        this.myRecordService.start();
    }

    @Override
    public void pause() {
        if (this.myRecordService == null) {
            theLogger.warning("No Record PollingService, unable to pause.");
            return;
        }
        this.myRecordService.pause();
    }

    @Override
    public void resume() {
        if (this.myRecordService == null) {
            theLogger.warning("No Record PollingService, unable to resume.");
            return;
        }
        if (this.myAdapter == null) {
            theLogger.warning("No Record Adapter, unable to resume.");
            return;
        }
        this.myRecordService.resume();
    }

    @Override
    public void stop() {
        if (this.myRecordService == null) {
            theLogger.warning("No Record PollingService to stop.");
            return;
        }
        this.myRecordService.stop();
    }

    protected void fireMessageEvent(Msg message) {
        for (Listener<Msg> listener : this.myListeners) {
            listener.handleEvent(message);
        }
    }

    @Override
    public void addListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeListener(Listener<Msg> listener) {
        if (listener == null) {
            return;
        }
        this.myListeners.remove(listener);
    }

    public void notifyListeners(Msg e) {
        this.fireMessageEvent(e);
    }

    class RecordAdapterHandler
    implements RecordAsyncReceiver.RecordHandler<Rec> {
        RecordAdapterHandler() {
        }

        @Override
        public void handleRecord(Rec record) {
            if (record == null) {
                theLogger.info("Ignoring null record.");
                return;
            }
            if (DefaultMessageAsyncReceiver.this.myAdapter == null) {
                theLogger.log(Level.WARNING, "No Record Adapter, unable to handle record: {0}.", record.toString());
                return;
            }
            Object message = DefaultMessageAsyncReceiver.this.myAdapter.adapt(record);
            if (message == null) {
                theLogger.log(Level.WARNING, "Null message returned when adapting record: {0}.", record.toString());
                return;
            }
            DefaultMessageAsyncReceiver.this.fireMessageEvent(message);
        }
    }
}

