/*
 * Decompiled with CFR 0.152.
 */
package org.rjung.util.launchpad;

import java.util.Arrays;
import java.util.Objects;
import org.rjung.util.launchpad.midi.Channel;
import org.rjung.util.launchpad.midi.Command;

public class MidiCommand {
    private final byte command;
    private final byte[] data;

    public MidiCommand(byte command, byte[] data) {
        this.command = command;
        this.data = (byte[])data.clone();
    }

    public byte getCommandByte() {
        return this.command;
    }

    public Command getCommand() {
        return Command.getCommand((byte)(this.command & 0xF0));
    }

    public Channel getChannel() {
        return Channel.getChannel((byte)(this.command & 0xF));
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MIDI[");
        result.append(String.format("%02x", this.command));
        result.append("/");
        result.append((Object)this.getCommand());
        result.append("/");
        result.append((Object)this.getChannel());
        for (int i = 0; i < this.data.length; ++i) {
            result.append(", ");
            result.append(String.format("%02x", this.data[i]));
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.command;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MidiCommand other = (MidiCommand)obj;
        return Objects.equals(this.command, other.command) && Arrays.equals(this.data, other.data);
    }

    public static class Builder {
        private byte statusbyte;
        private byte[] databytes;

        public Builder(Command command, Channel channel) {
            this.statusbyte = (byte)(command.getByte() ^ channel.getByte());
        }

        public Builder setDataBytes(byte[] databytes) {
            this.databytes = (byte[])databytes.clone();
            return this;
        }

        public MidiCommand toMidiCommand() {
            return new MidiCommand(this.statusbyte, this.databytes == null ? new byte[]{} : this.databytes);
        }
    }
}

