/*
 * Decompiled with CFR 0.152.
 */
package org.rjung.util.launchpad.midi;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import org.rjung.util.launchpad.LaunchpadHandler;
import org.rjung.util.launchpad.MidiCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidiReader
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MidiReader.class);
    private RandomAccessFile device;
    private Set<LaunchpadHandler> handlers;

    public MidiReader(RandomAccessFile device) {
        LOG.debug("Reader starting");
        this.handlers = new HashSet<LaunchpadHandler>();
        this.device = device;
    }

    public boolean addHandler(LaunchpadHandler handler) {
        return this.handlers.add(handler);
    }

    public boolean removeHandler(LaunchpadHandler handler) {
        return this.handlers.remove(handler);
    }

    @Override
    public void run() {
        try {
            while (true) {
                LOG.debug("Trying to read");
                byte command = this.device.readByte();
                LOG.debug("got: " + command);
                if (this.isStatusByte(command)) {
                    this.handle(new MidiCommand(command, this.getDataForCommand(command)));
                    continue;
                }
                LOG.error("Received invalid data packet: " + String.format("%02x", command));
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    private byte[] getDataForCommand(byte command) throws IOException {
        int length = this.isSysEx(command) ? this.device.readByte() : (this.isOneByteData(command) ? 1 : 2);
        byte[] data = new byte[length];
        for (int i = length; i > 0; --i) {
            data[length - i] = this.device.readByte();
        }
        return data;
    }

    private void handle(MidiCommand command) {
        LOG.debug("< " + command);
        for (LaunchpadHandler midiHandler : this.handlers) {
            midiHandler.recieve(command);
        }
    }

    private boolean isOneByteData(byte command) {
        return command >= -64 && command < -32;
    }

    private boolean isSysEx(byte command) {
        return command >= -16;
    }

    private boolean isStatusByte(byte command) {
        return command >= -128;
    }
}

