/*
 * Decompiled with CFR 0.152.
 */
package org.rjung.util.launchpad;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import org.rjung.util.launchpad.LaunchpadHandler;
import org.rjung.util.launchpad.MidiCommand;
import org.rjung.util.launchpad.midi.Channel;
import org.rjung.util.launchpad.midi.Color;
import org.rjung.util.launchpad.midi.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launchpad {
    private static final String FILE_ACCESS_MODE = "rw";
    private static final Logger LOG = LoggerFactory.getLogger(Launchpad.class);
    private RandomAccessFile device;
    private Thread thread;
    private Reader reader;

    public Launchpad(File device) throws FileNotFoundException {
        LOG.debug("Starting Launchpad with " + device);
        this.device = new RandomAccessFile(device, FILE_ACCESS_MODE);
        this.reader = new Reader(this.device);
        this.thread = new Thread(this.reader);
        this.thread.start();
    }

    public Launchpad(String device) throws FileNotFoundException {
        this(new File(device));
    }

    public void addHandler(LaunchpadHandler handler) {
        this.reader.addHandler(handler);
    }

    public void send(MidiCommand command) throws IOException {
        LOG.debug("> " + command);
        this.device.writeByte(command.getCommand());
        this.device.write(command.getData());
    }

    public void off(int x, int y) throws IOException {
        this.send(new MidiCommand.Builder(Command.NOTE_OFF, Channel.C1).setDataBytes(new byte[]{this.led(x, y), Color.OFF.getByte()}).toMidiCommand());
    }

    public void set(int x, int y, Color c) throws IOException {
        this.send(new MidiCommand.Builder(Command.NOTE_ON, Channel.C1).setDataBytes(new byte[]{this.led(x, y), c.getByte()}).toMidiCommand());
    }

    private byte led(int x, int y) {
        if (x < 0 || x > 16 || y < 0 || y > 16) {
            throw new IllegalArgumentException("x and y may only be within 1-16");
        }
        return (byte)(16 * x + y);
    }

    class Reader
    implements Runnable {
        private RandomAccessFile device;
        private Set<LaunchpadHandler> handlers;

        public Reader(RandomAccessFile device) {
            LOG.debug("Reader starting");
            this.handlers = new HashSet<LaunchpadHandler>();
            this.device = device;
        }

        public boolean addHandler(LaunchpadHandler handler) {
            return this.handlers.add(handler);
        }

        public boolean removeHandler(LaunchpadHandler handler) {
            return this.handlers.remove(handler);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    LOG.debug("Trying to read");
                    byte command = this.device.readByte();
                    LOG.debug("got: " + command);
                    if (this.isStatusByte(command)) {
                        this.handle(new MidiCommand(command, this.getDataForCommand(command)));
                        continue;
                    }
                    LOG.error("Received invalid data packet: " + String.format("%02x", command));
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return;
            }
        }

        private byte[] getDataForCommand(byte command) throws IOException {
            int length = this.isSysEx(command) ? this.device.readByte() : (this.isOneByteData(command) ? 1 : 2);
            byte[] data = new byte[length];
            for (int i = length; i > 0; --i) {
                data[length - i] = this.device.readByte();
            }
            return data;
        }

        private void handle(MidiCommand command) {
            LOG.debug("< " + command);
            for (LaunchpadHandler midiHandler : this.handlers) {
                midiHandler.recieve(command);
            }
        }

        private boolean isOneByteData(byte command) {
            return command >= -64 && command < -32;
        }

        private boolean isSysEx(byte command) {
            return command >= -16;
        }

        private boolean isStatusByte(byte command) {
            return command >= -128;
        }
    }
}

