/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.wrapper.lotus.domino;

import java.util.Arrays;
import java.util.logging.Logger;
import org.openntf.domino.Base;
import org.openntf.domino.DbDirectory;
import org.riverframework.River;
import org.riverframework.RiverException;
import org.riverframework.wrapper.Database;
import org.riverframework.wrapper.Session;
import org.riverframework.wrapper.lotus.domino.DefaultBase;
import org.riverframework.wrapper.lotus.domino.DefaultFactory;

public class DefaultSession
extends DefaultBase
implements Session<Base> {
    private static final Logger log = River.LOG_WRAPPER_LOTUS_DOMINO;
    private final DefaultFactory factory = DefaultFactory.getInstance();
    private volatile org.openntf.domino.Session __session = null;
    private String objectId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultSession(Session<Base> dummy, org.openntf.domino.Session obj) {
        this.__session = obj;
        DefaultSession defaultSession = this;
        synchronized (defaultSession) {
            this.objectId = DefaultSession.calcObjectId(this.__session);
        }
        log.fine("ObjectId:" + this.getObjectId());
    }

    public static String calcObjectId(org.openntf.domino.Session __session) {
        String objectId = "";
        if (__session != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(__session.getServerName());
            sb.append("**");
            sb.append(__session.getUserName());
            sb.append("**");
            sb.append(__session.hashCode());
            objectId = sb.toString();
        }
        return objectId;
    }

    public DefaultFactory getFactory() {
        return this.factory;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public org.openntf.domino.Session getNativeObject() {
        return this.__session;
    }

    public boolean isOpen() {
        return this.__session != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database<Base> createDatabase(String ... location) {
        log.fine("location=" + Arrays.deepToString(location));
        Database<Base> _database = null;
        org.openntf.domino.Database __database = null;
        if (location.length != 2) {
            throw new RiverException("It is expected two parameters: server and path, or server and replicaID");
        }
        DbDirectory dir = this.__session.getDbDirectory(location[0]);
        boolean found = false;
        org.openntf.domino.Database db = dir.getFirstDatabase(1247);
        while (db != null) {
            String fn = db.getFileName();
            if (fn.equalsIgnoreCase(location[1])) {
                found = true;
            }
            db = dir.getNextDatabase();
        }
        DefaultSession defaultSession = this;
        synchronized (defaultSession) {
            if (!found) {
                __database = dir.createDatabase(location[1]);
                _database = this.getFactory().getDatabase((Base)__database);
            } else {
                _database = this.getFactory().getDatabase(null);
            }
        }
        return _database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database<Base> getDatabase(String ... location) {
        log.fine("location=" + Arrays.deepToString(location));
        DefaultSession defaultSession = this;
        synchronized (defaultSession) {
            org.openntf.domino.Database __database = null;
            if (location.length != 2) {
                throw new RiverException("It is expected two parameters: server and path, or server and replicaID");
            }
            String server = location[0];
            String path = location[1];
            if (path.length() == 16) {
                log.finer("Trying with a replica ID");
                boolean res = false;
                __database = this.__session.getDatabase(null, null);
                res = __database.openByReplicaID(server, path);
                if (!res) {
                    __database = null;
                }
            }
            if (__database == null || !__database.isOpen()) {
                log.finer("Trying with a file path");
                __database = this.__session.getDatabase(server, path, false);
            }
            if (__database != null && !__database.isOpen()) {
                log.finer("The database could not be opened");
                __database = null;
            }
            Database<Base> database = this.getFactory().getDatabase((Base)__database);
            return database;
        }
    }

    public String getUserName() {
        String userName = "";
        userName = this.__session.getUserName();
        log.finest("getUserName=" + userName);
        return userName;
    }

    public void close() {
        log.fine("Closing factory");
        this.getFactory().close();
        log.fine("Recycling the session");
        this.__session = null;
        log.info("Session closed.");
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.objectId + ")";
    }
}

