/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.wrapper.lotus.domino;

import java.util.Iterator;
import java.util.logging.Logger;
import org.openntf.domino.Base;
import org.openntf.domino.DocumentCollection;
import org.openntf.domino.View;
import org.openntf.domino.ViewEntry;
import org.openntf.domino.ViewEntryCollection;
import org.riverframework.River;
import org.riverframework.wrapper.Document;
import org.riverframework.wrapper.DocumentIterator;
import org.riverframework.wrapper.Session;
import org.riverframework.wrapper.lotus.domino.DefaultBase;

class DefaultDocumentIterator
extends DefaultBase
implements DocumentIterator<Base> {
    private static final Logger log = River.LOG_WRAPPER_LOTUS_DOMINO;
    private Session<Base> _session = null;
    private volatile DocumentCollection __documentCollection = null;
    private volatile ViewEntryCollection __viewEntryCollection = null;
    private volatile org.openntf.domino.Document __document = null;
    private volatile ViewEntry __viewEntry = null;
    private Type type = null;
    private String objectId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultDocumentIterator(Session<Base> s, DocumentCollection __obj) {
        this.type = Type.COLLECTION;
        this._session = s;
        this.__documentCollection = __obj;
        Session<Base> session = this._session;
        synchronized (session) {
            this.__document = this.__documentCollection.getFirstDocument();
            this.objectId = DefaultDocumentIterator.calcObjectId(this.__documentCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultDocumentIterator(Session<Base> s, View __obj) {
        this.type = Type.VIEW_ENTRY_COLLECTION;
        Session<Base> session = this._session = s;
        synchronized (session) {
            this.__viewEntryCollection = __obj.getAllEntries();
            this.__viewEntry = this.__viewEntryCollection.getFirstEntry();
            this.updateCurrentDocumentFromViewEntry();
            this.objectId = DefaultDocumentIterator.calcObjectId(this.__viewEntryCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultDocumentIterator(Session<Base> s, ViewEntryCollection __obj) {
        this.type = Type.VIEW_ENTRY_COLLECTION;
        this._session = s;
        this.__viewEntryCollection = __obj;
        Session<Base> session = this._session;
        synchronized (session) {
            this.__viewEntry = this.__viewEntryCollection.getFirstEntry();
            this.updateCurrentDocumentFromViewEntry();
            this.objectId = DefaultDocumentIterator.calcObjectId(this.__viewEntryCollection);
        }
    }

    private boolean isViewEntryValid(ViewEntry __ve) {
        if (__ve == null) {
            return true;
        }
        org.openntf.domino.Document __doc = __ve.getDocument();
        if (__doc == null) {
            return false;
        }
        return !__doc.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentDocumentFromViewEntry() {
        Session<Base> session = this._session;
        synchronized (session) {
            while (!this.isViewEntryValid(this.__viewEntry)) {
                this.__viewEntry = this.__viewEntryCollection.getNextEntry((lotus.domino.ViewEntry)this.__viewEntry);
            }
            log.finest("Current view entry=" + (this.__viewEntry == null ? "<null>" : Integer.valueOf(this.__viewEntry.getDocument().hashCode())));
            this.__document = this.__viewEntry == null ? null : this.__viewEntry.getDocument();
        }
    }

    private static String internalCalcObjectId(Base __object) {
        String objectId = "";
        if (__object != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(__object.getClass().getName());
            sb.append("**");
            sb.append(__object.hashCode());
            objectId = sb.toString();
        }
        return objectId;
    }

    public static String calcObjectId(DocumentCollection __object) {
        return DefaultDocumentIterator.internalCalcObjectId((Base)__object);
    }

    public static String calcObjectId(ViewEntryCollection __object) {
        return DefaultDocumentIterator.internalCalcObjectId((Base)__object);
    }

    public static String calcObjectId(View __object) {
        return DefaultDocumentIterator.internalCalcObjectId((Base)__object);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean hasNext() {
        return this.__document != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document<Base> next() {
        org.openntf.domino.Document __current = null;
        Session<Base> session = this._session;
        synchronized (session) {
            switch (this.type) {
                case COLLECTION: {
                    __current = this.__document;
                    this.__document = this.__documentCollection.getNextDocument((lotus.domino.Document)this.__document);
                    break;
                }
                case VIEW_ENTRY_COLLECTION: {
                    __current = this.__document;
                    this.__viewEntry = this.__viewEntryCollection.getNextEntry((lotus.domino.ViewEntry)this.__viewEntry);
                    this.updateCurrentDocumentFromViewEntry();
                }
            }
            Document _doc = this._session.getFactory().getDocument((Object)__current);
            return _doc;
        }
    }

    public DocumentIterator<Base> iterator() {
        return this;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DocumentIterator<Base> deleteAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Document doc = (Document)iterator.next();
            doc.delete();
        }
        return this;
    }

    public Base getNativeObject() {
        switch (this.type) {
            case COLLECTION: {
                return this.__documentCollection;
            }
            case VIEW_ENTRY_COLLECTION: {
                return this.__viewEntryCollection;
            }
        }
        return null;
    }

    public boolean isOpen() {
        switch (this.type) {
            case COLLECTION: {
                return this.__documentCollection != null;
            }
            case VIEW_ENTRY_COLLECTION: {
                return this.__viewEntryCollection != null;
            }
        }
        return false;
    }

    public void close() {
        log.finest("Closing: id=" + this.objectId + " (" + this.hashCode() + ")");
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.objectId + ")";
    }

    private static enum Type {
        COLLECTION,
        VIEW_ENTRY_COLLECTION;

    }
}

