/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.wrapper.lotus.domino;

import java.util.regex.Pattern;
import org.openntf.domino.Base;
import org.openntf.domino.DocumentCollection;
import org.riverframework.RiverException;
import org.riverframework.wrapper.Database;
import org.riverframework.wrapper.Document;
import org.riverframework.wrapper.DocumentIterator;
import org.riverframework.wrapper.Session;
import org.riverframework.wrapper.View;
import org.riverframework.wrapper.lotus.domino.DefaultBase;

class DefaultDatabase
extends DefaultBase
implements Database<Base> {
    protected Session<?> _session = null;
    protected volatile org.openntf.domino.Database __database = null;
    private String objectId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultDatabase(Session<?> _s, org.openntf.domino.Database __obj) {
        this.__database = __obj;
        Session<?> session = this._session = _s;
        synchronized (session) {
            this.objectId = DefaultDatabase.calcObjectId(this.__database);
        }
    }

    public org.openntf.domino.Database getNativeObject() {
        return this.__database;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static String calcObjectId(org.openntf.domino.Database __database) {
        String objectId = "";
        if (__database != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(__database.getServer());
            sb.append("**");
            sb.append(__database.getFilePath());
            objectId = sb.toString();
        }
        return objectId;
    }

    public String getServer() {
        return this.__database.getServer();
    }

    public String getFilePath() {
        return this.__database.getFilePath();
    }

    public String getName() {
        return this.__database.getTitle();
    }

    public boolean isOpen() {
        return this.__database != null && this.__database.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document<Base> createDocument(String ... parameters) {
        Session<?> session = this._session;
        synchronized (session) {
            org.openntf.domino.Document __doc = null;
            __doc = this.__database.createDocument();
            Document doc = this._session.getFactory().getDocument((Object)__doc);
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document<Base> getDocument(String ... parameters) {
        Session<?> session = this._session;
        synchronized (session) {
            org.openntf.domino.Document __doc = null;
            if (parameters.length > 0) {
                String id = parameters[0];
                String[] temp = id.split(Pattern.quote("**"));
                if (temp.length == 3) {
                    id = temp[2];
                }
                try {
                    if (id.length() == 32) {
                        __doc = this.__database.getDocumentByUNID(id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (__doc == null && id.length() == 8) {
                        __doc = this.__database.getDocumentByID(id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Document doc = this._session.getFactory().getDocument(__doc);
            return doc;
        }
    }

    public View<Base> createView(String ... parameters) {
        org.openntf.domino.View __view = null;
        String name = null;
        if (parameters.length == 1) {
            name = parameters[0];
            __view = this.__database.createView(name);
        } else if (parameters.length == 2) {
            name = parameters[0];
            String selectionFormula = parameters[1];
            __view = this.__database.createView(name, selectionFormula);
        } else {
            throw new RiverException("It was expected these parameters: name (required) and selection formula (optional).");
        }
        if (name != null && !name.equals("") && __view != null) {
            __view = null;
        }
        View<Base> _view = this.getView(name);
        return _view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<Base> getView(String ... parameters) {
        Session<?> session = this._session;
        synchronized (session) {
            org.openntf.domino.View __view = null;
            if (parameters.length > 0) {
                String id = parameters[0];
                __view = this.__database.getView(id);
            }
            if (__view != null) {
                __view.setAutoUpdate(false);
            }
            View _view = this._session.getFactory().getView(__view);
            return _view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentIterator<Base> getAllDocuments() {
        Session<?> session = this._session;
        synchronized (session) {
            DocumentCollection _col = this.__database.getAllDocuments();
            DocumentIterator _iterator = this._session.getFactory().getDocumentIterator((Object)_col);
            return _iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentIterator<Base> search(String query) {
        Session<?> session = this._session;
        synchronized (session) {
            DocumentCollection _col = this.__database.FTSearch(query);
            DocumentIterator _iterator = this._session.getFactory().getDocumentIterator((Object)_col);
            return _iterator;
        }
    }

    public Database<Base> refreshSearchIndex() {
        this.__database.updateFTIndex(false);
        return this;
    }

    public void delete() {
        if (this.__database != null) {
            this.__database.remove();
        }
        this.close();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.objectId + ")";
    }

    public void close() {
    }
}

